/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ServiceLoader;

final class MeterProviderConfiguration {
    static MeterProvider configureMeterProvider(Resource resource, ConfigProperties config, ClassLoader serviceClassLoader) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        String exemplarFilter = config.getString("otel.metrics.exemplar.filter");
        if (exemplarFilter == null) {
            exemplarFilter = "with_sampled_trace";
        }
        switch (exemplarFilter) {
            case "none": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.neverSample());
                break;
            }
            case "all": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.alwaysSample());
                break;
            }
            default: {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.sampleWithTraces());
            }
        }
        for (SdkMeterProviderConfigurer configurer : ServiceLoader.load(SdkMeterProviderConfigurer.class, serviceClassLoader)) {
            configurer.configure(meterProviderBuilder, config);
        }
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName == null || exporterName.equals("none")) {
            return MeterProvider.noop();
        }
        MetricExporterConfiguration.configureExporter(exporterName, config, serviceClassLoader, meterProviderBuilder);
        SdkMeterProvider meterProvider = meterProviderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)meterProvider).close()));
        return meterProvider;
    }

    private MeterProviderConfiguration() {
    }
}

