/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.otlp.internal.retry.RetryPolicy;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class OtlpConfigUtil {
    static final String DATA_TYPE_TRACES = "traces";
    static final String DATA_TYPE_METRICS = "metrics";
    static final String DATA_TYPE_LOGS = "logs";
    static final String PROTOCOL_GRPC = "grpc";
    static final String PROTOCOL_HTTP_PROTOBUF = "http/protobuf";

    static String getOtlpProtocol(String dataType, ConfigProperties config) {
        String protocol = config.getString("otel.exporter.otlp." + dataType + ".protocol");
        if (protocol == null) {
            protocol = config.getString("otel.exporter.otlp.protocol");
        }
        return protocol == null ? PROTOCOL_GRPC : protocol;
    }

    static void configureOtlpExporterBuilder(String dataType, ConfigProperties config, Consumer<String> setEndpoint, BiConsumer<String, String> addHeader, Consumer<String> setCompression, Consumer<Duration> setTimeout, Consumer<byte[]> setTrustedCertificates, Consumer<RetryPolicy> setRetryPolicy) {
        Boolean retryEnabled;
        String certificate;
        Duration timeout;
        Map headers;
        String protocol = OtlpConfigUtil.getOtlpProtocol(dataType, config);
        boolean isHttpProtobuf = protocol.equals(PROTOCOL_HTTP_PROTOBUF);
        URL endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp." + dataType + ".endpoint"), isHttpProtobuf);
        if (endpoint != null) {
            if (endpoint.getPath().isEmpty()) {
                endpoint = OtlpConfigUtil.createUrl(endpoint, "/");
            }
        } else {
            endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp.endpoint"), isHttpProtobuf);
            if (endpoint != null && isHttpProtobuf) {
                String path = endpoint.getPath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + OtlpConfigUtil.signalPath(dataType);
                endpoint = OtlpConfigUtil.createUrl(endpoint, path);
            }
        }
        if (endpoint != null) {
            setEndpoint.accept(endpoint.toString());
        }
        if ((headers = config.getMap("otel.exporter.otlp." + dataType + ".headers")).isEmpty()) {
            headers = config.getMap("otel.exporter.otlp.headers");
        }
        headers.forEach(addHeader);
        String compression = config.getString("otel.exporter.otlp." + dataType + ".compression");
        if (compression == null) {
            compression = config.getString("otel.exporter.otlp.compression");
        }
        if (compression != null) {
            setCompression.accept(compression);
        }
        if ((timeout = config.getDuration("otel.exporter.otlp." + dataType + ".timeout")) == null) {
            timeout = config.getDuration("otel.exporter.otlp.timeout");
        }
        if (timeout != null) {
            setTimeout.accept(timeout);
        }
        if ((certificate = config.getString("otel.exporter.otlp." + dataType + ".certificate")) == null) {
            certificate = config.getString("otel.exporter.otlp.certificate");
        }
        if (certificate != null) {
            byte[] certificateBytes;
            Path path = Paths.get(certificate, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new ConfigurationException("Invalid OTLP certificate path: " + path);
            }
            try {
                certificateBytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error reading OTLP certificate.", (Throwable)e);
            }
            setTrustedCertificates.accept(certificateBytes);
        }
        if ((retryEnabled = config.getBoolean("otel.experimental.exporter.otlp.retry.enabled")) != null && retryEnabled.booleanValue()) {
            setRetryPolicy.accept(RetryPolicy.getDefault());
        }
    }

    static void configureOtlpAggregationTemporality(ConfigProperties config, Consumer<AggregationTemporality> setAggregationTemporality) {
        AggregationTemporality temporality;
        String temporalityStr = config.getString("otel.exporter.otlp.metrics.temporality");
        if (temporalityStr == null) {
            return;
        }
        try {
            temporality = AggregationTemporality.valueOf((String)temporalityStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unrecognized aggregation temporality: " + temporalityStr, (Throwable)e);
        }
        setAggregationTemporality.accept(temporality);
    }

    private static URL createUrl(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unexpected exception creating URL.", (Throwable)e);
        }
    }

    @Nullable
    private static URL validateEndpoint(@Nullable String endpoint, boolean allowPath) {
        URL endpointUrl;
        if (endpoint == null) {
            return null;
        }
        try {
            endpointUrl = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("OTLP endpoint must be a valid URL: " + endpoint, (Throwable)e);
        }
        if (!endpointUrl.getProtocol().equals("http") && !endpointUrl.getProtocol().equals("https")) {
            throw new ConfigurationException("OTLP endpoint scheme must be http or https: " + endpointUrl.getProtocol());
        }
        if (endpointUrl.getQuery() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a query string: " + endpointUrl.getQuery());
        }
        if (endpointUrl.getRef() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a fragment: " + endpointUrl.getRef());
        }
        if (!(allowPath || endpointUrl.getPath().isEmpty() || endpointUrl.getPath().equals("/"))) {
            throw new ConfigurationException("OTLP endpoint must not have a path: " + endpointUrl.getPath());
        }
        return endpointUrl;
    }

    private static String signalPath(String dataType) {
        switch (dataType) {
            case "metrics": {
                return "v1/metrics";
            }
            case "traces": {
                return "v1/traces";
            }
            case "logs": {
                return "v1/logs";
            }
        }
        throw new IllegalArgumentException("Cannot determine signal path for unrecognized data type: " + dataType);
    }

    private OtlpConfigUtil() {
    }
}

