/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.logging.LoggingMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusCollector;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    static void configureExporter(String name, ConfigProperties config, SdkMeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                MetricExporterConfiguration.configureOtlpMetrics(config, meterProvider);
                return;
            }
            case "prometheus": {
                MetricExporterConfiguration.configurePrometheusMetrics(config, meterProvider);
                return;
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
                MetricExporterConfiguration.configureLoggingMetrics(config, meterProvider);
                return;
            }
        }
    }

    private static void configureLoggingMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        LoggingMetricExporter exporter = new LoggingMetricExporter();
        MetricExporterConfiguration.configureIntervalMetricReader(config, meterProvider, (MetricExporter)exporter);
    }

    @Nullable
    static OtlpGrpcMetricExporter configureOtlpMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        try {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP Metrics Exporter", "opentelemetry-exporter-otlp-metrics");
        }
        catch (ConfigurationException e) {
            return null;
        }
        OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
        String endpoint = config.getString("otel.exporter.otlp.metrics.endpoint");
        if (endpoint == null) {
            endpoint = config.getString("otel.exporter.otlp.endpoint");
        }
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        config.getCommaSeparatedMap("otel.exporter.otlp.headers").forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        Long timeoutMillis = config.getLong("otel.exporter.otlp.timeout");
        if (timeoutMillis != null) {
            builder.setTimeout(Duration.ofMillis(timeoutMillis));
        }
        OtlpGrpcMetricExporter exporter = builder.build();
        MetricExporterConfiguration.configureIntervalMetricReader(config, meterProvider, (MetricExporter)exporter);
        return exporter;
    }

    private static void configureIntervalMetricReader(ConfigProperties config, SdkMeterProvider meterProvider, MetricExporter exporter) {
        IntervalMetricReaderBuilder readerBuilder = IntervalMetricReader.builder().setMetricProducers(Collections.singleton(meterProvider)).setMetricExporter(exporter);
        Long exportIntervalMillis = config.getLong("otel.imr.export.interval");
        if (exportIntervalMillis != null) {
            readerBuilder.setExportIntervalMillis(exportIntervalMillis.longValue());
        }
        IntervalMetricReader reader = readerBuilder.buildAndStart();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((IntervalMetricReader)reader).shutdown()));
    }

    private static void configurePrometheusMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        HTTPServer server;
        String host;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.prometheus.PrometheusCollector", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        PrometheusCollector.builder().setMetricProducer((MetricProducer)meterProvider).buildAndRegister();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port == null) {
            port = 9464;
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) == null) {
            host = "0.0.0.0";
        }
        try {
            server = new HTTPServer(host, port.intValue(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create Prometheus server", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HTTPServer)server).stop()));
    }

    private MetricExporterConfiguration() {
    }
}

