/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.aws.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.extension.trace.aws.resource.AwsResourceConstants;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.resources.ResourceProvider;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanstalkResource
extends ResourceProvider {
    private static final Logger logger = Logger.getLogger(BeanstalkResource.class.getName());
    private static final String DEVELOPMENT_ID = "deployment_id";
    private static final String VERSION_LABEL = "version_label";
    private static final String ENVIRONMENT_NAME = "environment_name";
    private static final String BEANSTALK_CONF_PATH = "/var/elasticbeanstalk/xray/environment.conf";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final String configPath;

    public BeanstalkResource() {
        this(BEANSTALK_CONF_PATH);
    }

    @VisibleForTesting
    BeanstalkResource(String configPath) {
        this.configPath = configPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attributes getAttributes() {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            return Attributes.empty();
        }
        Attributes.Builder attrBuilders = Attributes.builder();
        try (JsonParser parser = JSON_FACTORY.createParser(configFile);){
            parser.nextToken();
            if (!parser.isExpectedStartObjectToken()) {
                logger.log(Level.WARNING, "Invalid Beanstalk config: ", this.configPath);
                Attributes attributes = attrBuilders.build();
                return attributes;
            }
            block18: while (parser.nextToken() != JsonToken.END_OBJECT) {
                parser.nextValue();
                String value = parser.getText();
                switch (parser.getCurrentName()) {
                    case "deployment_id": {
                        attrBuilders.put(ResourceAttributes.SERVICE_INSTANCE, (Object)value);
                        continue block18;
                    }
                    case "version_label": {
                        attrBuilders.put(ResourceAttributes.SERVICE_VERSION, (Object)value);
                        continue block18;
                    }
                    case "environment_name": {
                        attrBuilders.put(ResourceAttributes.SERVICE_NAMESPACE, (Object)value);
                        continue block18;
                    }
                }
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not parse Beanstalk config.", e);
            return Attributes.empty();
        }
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)AwsResourceConstants.cloudProvider());
        return attrBuilders.build();
    }
}

