/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.aws.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.extension.trace.aws.resource.AwsResourceConstants;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.resources.ResourceProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ec2Resource
extends ResourceProvider {
    private static final Logger logger = Logger.getLogger(Ec2Resource.class.getName());
    private static final int TIMEOUT_MILLIS = 2000;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String DEFAULT_IMDS_ENDPOINT = "169.254.169.254";
    private final URL identityDocumentUrl;
    private final URL hostnameUrl;
    private final URL tokenUrl;

    public Ec2Resource() {
        this(System.getProperty("otel.aws.imds.endpointOverride", DEFAULT_IMDS_ENDPOINT));
    }

    @VisibleForTesting
    Ec2Resource(String endpoint) {
        String urlBase = "http://" + endpoint;
        try {
            this.identityDocumentUrl = new URL(urlBase + "/latest/dynamic/instance-identity/document");
            this.hostnameUrl = new URL(urlBase + "/latest/meta-data/hostname");
            this.tokenUrl = new URL(urlBase + "/latest/api/token");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal endpoint: " + endpoint, e);
        }
    }

    private static String fetchString(String httpMethod, URL url, String token, boolean includeTtl) {
        int responseCode;
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error connecting to IMDS.", e);
            return "";
        }
        try {
            connection.setRequestMethod(httpMethod);
        }
        catch (ProtocolException e) {
            logger.log(Level.FINE, "Unknown HTTP method, this is a programming bug.", e);
            return "";
        }
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        if (includeTtl) {
            connection.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", "60");
        }
        if (!token.isEmpty()) {
            connection.setRequestProperty("X-aws-ec2-metadata-token", token);
        }
        try {
            responseCode = connection.getResponseCode();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error connecting to IMDS: ", e);
            return "";
        }
        if (responseCode != 200) {
            logger.log(Level.FINE, "Error reponse from IMDS: code (" + responseCode + ") text " + Ec2Resource.readResponseString(connection));
        }
        return Ec2Resource.readResponseString(connection).trim();
    }

    private static String readResponseString(HttpURLConnection connection) {
        InputStream is2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            is2 = connection.getInputStream();
            try {
                ByteStreams.copy((InputStream)is2, (OutputStream)os);
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        try {
            is2 = connection.getErrorStream();
            try {
                if (is2 != null) {
                    ByteStreams.copy((InputStream)is2, (OutputStream)os);
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException is3) {
            // empty catch block
        }
        try {
            return os.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported can't happen.", e);
        }
    }

    public Attributes getAttributes() {
        String token = this.fetchToken();
        String identity = this.fetchIdentity(token);
        if (identity.isEmpty()) {
            return Attributes.empty();
        }
        String hostname = this.fetchHostname(token);
        Attributes.Builder attrBuilders = Attributes.builder();
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)AwsResourceConstants.cloudProvider());
        try (JsonParser parser = JSON_FACTORY.createParser(identity);){
            parser.nextToken();
            if (!parser.isExpectedStartObjectToken()) {
                throw new IOException("Invalid JSON:" + identity);
            }
            block23: while (parser.nextToken() != JsonToken.END_OBJECT) {
                String value = parser.nextTextValue();
                switch (parser.getCurrentName()) {
                    case "instanceId": {
                        attrBuilders.put(ResourceAttributes.HOST_ID, (Object)value);
                        continue block23;
                    }
                    case "availabilityZone": {
                        attrBuilders.put(ResourceAttributes.CLOUD_ZONE, (Object)value);
                        continue block23;
                    }
                    case "instanceType": {
                        attrBuilders.put(ResourceAttributes.HOST_TYPE, (Object)value);
                        continue block23;
                    }
                    case "imageId": {
                        attrBuilders.put(ResourceAttributes.HOST_IMAGE_ID, (Object)value);
                        continue block23;
                    }
                    case "accountId": {
                        attrBuilders.put(ResourceAttributes.CLOUD_ACCOUNT, (Object)value);
                        continue block23;
                    }
                    case "region": {
                        attrBuilders.put(ResourceAttributes.CLOUD_REGION, (Object)value);
                        continue block23;
                    }
                }
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not parse identity document, resource not filled.", e);
            return Attributes.empty();
        }
        attrBuilders.put(ResourceAttributes.HOST_HOSTNAME, (Object)hostname);
        attrBuilders.put(ResourceAttributes.HOST_NAME, (Object)hostname);
        return attrBuilders.build();
    }

    private String fetchToken() {
        return Ec2Resource.fetchString("PUT", this.tokenUrl, "", true);
    }

    private String fetchIdentity(String token) {
        return Ec2Resource.fetchString("GET", this.identityDocumentUrl, token, false);
    }

    private String fetchHostname(String token) {
        return Ec2Resource.fetchString("GET", this.hostnameUrl, token, false);
    }
}

