/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.aws.resource;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.extension.trace.aws.resource.AwsResourceConstants;
import io.opentelemetry.sdk.extension.trace.aws.resource.DockerHelper;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.resources.ResourceProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EcsResource
extends ResourceProvider {
    private static final Logger logger = Logger.getLogger(EcsResource.class.getName());
    private static final String ECS_METADATA_KEY_V4 = "ECS_CONTAINER_METADATA_URI_V4";
    private static final String ECS_METADATA_KEY_V3 = "ECS_CONTAINER_METADATA_URI";
    private final Map<String, String> sysEnv;
    private final DockerHelper dockerHelper;

    public EcsResource() {
        this(System.getenv(), new DockerHelper());
    }

    @VisibleForTesting
    EcsResource(Map<String, String> sysEnv, DockerHelper dockerHelper) {
        this.sysEnv = sysEnv;
        this.dockerHelper = dockerHelper;
    }

    public Attributes getAttributes() {
        if (!this.isOnEcs()) {
            return Attributes.empty();
        }
        Attributes.Builder attrBuilders = Attributes.builder();
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)AwsResourceConstants.cloudProvider());
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            attrBuilders.put(ResourceAttributes.CONTAINER_NAME, (Object)hostName);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Could not get docker container name from hostname.", e);
        }
        String containerId = this.dockerHelper.getContainerId();
        if (!Strings.isNullOrEmpty((String)containerId)) {
            attrBuilders.put(ResourceAttributes.CONTAINER_ID, (Object)containerId);
        }
        return attrBuilders.build();
    }

    private boolean isOnEcs() {
        return !Strings.isNullOrEmpty((String)this.sysEnv.get(ECS_METADATA_KEY_V3)) || !Strings.isNullOrEmpty((String)this.sysEnv.get(ECS_METADATA_KEY_V4));
    }
}

