/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.aws.resource;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DockerHelper {
    private static final Logger logger = Logger.getLogger(DockerHelper.class.getName());
    private static final int CONTAINER_ID_LENGTH = 64;
    private static final String DEFAULT_CGROUP_PATH = "/proc/self/cgroup";
    private final String cgroupPath;

    DockerHelper() {
        this(DEFAULT_CGROUP_PATH);
    }

    DockerHelper(String cgroupPath) {
        this.cgroupPath = cgroupPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContainerId() {
        try (BufferedReader br = new BufferedReader(new FileReader(this.cgroupPath));){
            String line;
            do {
                if ((line = br.readLine()) == null) return "";
            } while (line.length() <= 64);
            String string = line.substring(line.length() - 64);
            return string;
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "Failed to read container id, cgroup file does not exist.");
            return "";
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read container id: " + e.getMessage());
        }
        return "";
    }
}

