/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.zpages;

import io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class SpanBucket {
    private static final int LATENCY_BUCKET_SIZE = 16;
    private static final int ERROR_BUCKET_SIZE = 8;
    private final AtomicReferenceArray<ReadableSpan> spans;
    private final AtomicInteger index;
    private final int bucketSize;

    SpanBucket(boolean isLatencyBucket) {
        this.bucketSize = isLatencyBucket ? 16 : 8;
        this.spans = new AtomicReferenceArray(this.bucketSize);
        this.index = new AtomicInteger();
    }

    void add(ReadableSpan span) {
        this.spans.set(SpanBucket.remainder(this.index.getAndIncrement(), this.bucketSize), span);
    }

    int size() {
        for (int i = this.bucketSize - 1; i >= 0; --i) {
            if (this.spans.get(i) == null) continue;
            return i + 1;
        }
        return 0;
    }

    void addTo(List<ReadableSpan> result) {
        ReadableSpan span;
        for (int i = 0; i < this.bucketSize && (span = this.spans.get(i)) != null; ++i) {
            result.add(span);
        }
    }

    private static int remainder(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) % Integer.toUnsignedLong(divisor));
    }
}

