/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.zpages;

import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class ZPageLogo {
    private static final String LOGO = "logo.png";
    private static final String FAVICON = "favicon.png";

    private ZPageLogo() {
    }

    static String getLogoPath() {
        return "/logo.png";
    }

    static String getFaviconPath() {
        return "/favicon.png";
    }

    static void registerStaticResources(HttpServer httpServer) {
        ZPageLogo.registerStaticResource(httpServer, ZPageLogo.getLogoPath(), ZPageLogo.getResourceBytes(LOGO));
        ZPageLogo.registerStaticResource(httpServer, ZPageLogo.getFaviconPath(), ZPageLogo.getResourceBytes(FAVICON));
    }

    private static void registerStaticResource(HttpServer httpServer, String path, byte[] bytes) {
        httpServer.createContext(path, exchange -> {
            try {
                exchange.sendResponseHeaders(200, bytes.length);
                exchange.getResponseBody().write(bytes);
            }
            finally {
                exchange.close();
            }
        });
    }

    private static byte[] getResourceBytes(String resource) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = ZPageLogo.class.getClassLoader().getResourceAsStream(resource);){
            ZPageLogo.readTo(is, os);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error retrieving OpenTelemetry resource " + resource, t);
        }
        return os.toByteArray();
    }

    private static void readTo(InputStream is, ByteArrayOutputStream os) throws IOException {
        int b;
        while ((b = is.read()) != -1) {
            os.write(b);
        }
    }
}

