/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.zpages;

import com.sun.net.httpserver.HttpServer;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.IndexZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TraceConfigzZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezDataAggregator;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezSpanProcessor;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezTraceConfigSupplier;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageHttpHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageLogo;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ZPageServer {
    private static final int HTTPSERVER_BACKLOG = 5;
    private static final int HTTPSERVER_STOP_DELAY = 1;
    private static final TracezSpanProcessor tracezSpanProcessor = TracezSpanProcessor.builder().build();
    private static final TracezTraceConfigSupplier tracezTraceConfigSupplier = new TracezTraceConfigSupplier();
    private static final TracezDataAggregator tracezDataAggregator = new TracezDataAggregator(tracezSpanProcessor);
    private static final ZPageHandler tracezZPageHandler = new TracezZPageHandler(tracezDataAggregator);
    private static final ZPageHandler traceConfigzZPageHandler = new TraceConfigzZPageHandler(tracezTraceConfigSupplier);
    private static final ZPageHandler indexZPageHandler = new IndexZPageHandler(Arrays.asList(tracezZPageHandler, traceConfigzZPageHandler));
    private static final Object mutex = new Object();
    @Nullable
    private static HttpServer server;

    public static Supplier<SpanLimits> getTracezTraceConfigSupplier() {
        return tracezTraceConfigSupplier;
    }

    public static Sampler getTracezSampler() {
        return tracezTraceConfigSupplier;
    }

    public static SpanProcessor getSpanProcessor() {
        return tracezSpanProcessor;
    }

    static void registerIndexZPageHandler(HttpServer server) {
        server.createContext(indexZPageHandler.getUrlPath(), new ZPageHttpHandler(indexZPageHandler));
    }

    static void registerTracezZPageHandler(HttpServer server) {
        server.createContext(tracezZPageHandler.getUrlPath(), new ZPageHttpHandler(tracezZPageHandler));
    }

    static void registerTraceConfigzZPageHandler(HttpServer server) {
        server.createContext(traceConfigzZPageHandler.getUrlPath(), new ZPageHttpHandler(traceConfigzZPageHandler));
    }

    public static void registerAllPagesToHttpServer(HttpServer server) {
        ZPageServer.registerIndexZPageHandler(server);
        ZPageServer.registerTracezZPageHandler(server);
        ZPageServer.registerTraceConfigzZPageHandler(server);
        ZPageLogo.registerStaticResources(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stop() {
        Object object = mutex;
        synchronized (object) {
            if (server == null) {
                return;
            }
            server.stop(1);
            server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHttpServerAndRegisterAllPages(int port) throws IOException {
        Object object = mutex;
        synchronized (object) {
            if (server != null) {
                throw new IllegalStateException("The HttpServer is already started.");
            }
            server = HttpServer.create(new InetSocketAddress(port), 5);
            ZPageServer.registerAllPagesToHttpServer(server);
            server.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ZPageServer.stop();
            }
        });
    }

    private ZPageServer() {
    }
}

