/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.zpages;

import java.util.concurrent.TimeUnit;

enum LatencyBoundary {
    ZERO_MICROSx10(0L, TimeUnit.MICROSECONDS.toNanos(10L)),
    MICROSx10_MICROSx100(TimeUnit.MICROSECONDS.toNanos(10L), TimeUnit.MICROSECONDS.toNanos(100L)),
    MICROSx100_MILLIx1(TimeUnit.MICROSECONDS.toNanos(100L), TimeUnit.MILLISECONDS.toNanos(1L)),
    MILLIx1_MILLIx10(TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(10L)),
    MILLIx10_MILLIx100(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(100L)),
    MILLIx100_SECONDx1(TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.SECONDS.toNanos(1L)),
    SECONDx1_SECONDx10(TimeUnit.SECONDS.toNanos(1L), TimeUnit.SECONDS.toNanos(10L)),
    SECONDx10_SECONDx100(TimeUnit.SECONDS.toNanos(10L), TimeUnit.SECONDS.toNanos(100L)),
    SECONDx100_MAX(TimeUnit.SECONDS.toNanos(100L), Long.MAX_VALUE);

    private final long latencyLowerBound;
    private final long latencyUpperBound;

    private LatencyBoundary(long latencyLowerBound, long latencyUpperBound) {
        this.latencyLowerBound = latencyLowerBound;
        this.latencyUpperBound = latencyUpperBound;
    }

    long getLatencyLowerBound() {
        return this.latencyLowerBound;
    }

    long getLatencyUpperBound() {
        return this.latencyUpperBound;
    }

    static LatencyBoundary getBoundary(long latencyNanos) {
        for (LatencyBoundary bucket : LatencyBoundary.values()) {
            if (latencyNanos < bucket.getLatencyLowerBound() || latencyNanos >= bucket.getLatencyUpperBound()) continue;
            return bucket;
        }
        return ZERO_MICROSx10;
    }
}

