/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.zpages;

import com.sun.net.httpserver.HttpServer;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.IndexZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TraceConfigzZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezDataAggregator;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezSpanProcessor;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezTraceConfigSupplier;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.TracezZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageHttpHandler;
import io.opentelemetry.sdk.extension.incubator.trace.zpages.ZPageLogo;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ZPageServer {
    private static final int HTTPSERVER_BACKLOG = 5;
    private static final int HTTPSERVER_STOP_DELAY = 1;
    private final TracezSpanProcessor tracezSpanProcessor = TracezSpanProcessor.builder().build();
    private final TracezTraceConfigSupplier tracezTraceConfigSupplier = new TracezTraceConfigSupplier();
    private final TracezDataAggregator tracezDataAggregator = new TracezDataAggregator(this.tracezSpanProcessor);
    private final ZPageHandler tracezZPageHandler = new TracezZPageHandler(this.tracezDataAggregator);
    private final ZPageHandler traceConfigzZPageHandler = new TraceConfigzZPageHandler(this.tracezTraceConfigSupplier);
    private final ZPageHandler indexZPageHandler = new IndexZPageHandler(Arrays.asList(this.tracezZPageHandler, this.traceConfigzZPageHandler));
    private final Object mutex = new Object();
    @Nullable
    private HttpServer server;

    private ZPageServer() {
    }

    public static ZPageServer create() {
        return new ZPageServer();
    }

    public Supplier<SpanLimits> getTracezTraceConfigSupplier() {
        return this.tracezTraceConfigSupplier;
    }

    public Sampler getTracezSampler() {
        return this.tracezTraceConfigSupplier;
    }

    public SpanProcessor getSpanProcessor() {
        return this.tracezSpanProcessor;
    }

    private void registerIndexZPageHandler(HttpServer server) {
        server.createContext(this.indexZPageHandler.getUrlPath(), new ZPageHttpHandler(this.indexZPageHandler));
    }

    private void registerTracezZPageHandler(HttpServer server) {
        server.createContext(this.tracezZPageHandler.getUrlPath(), new ZPageHttpHandler(this.tracezZPageHandler));
    }

    private void registerTraceConfigzZPageHandler(HttpServer server) {
        server.createContext(this.traceConfigzZPageHandler.getUrlPath(), new ZPageHttpHandler(this.traceConfigzZPageHandler));
    }

    public void registerAllPagesToHttpServer(HttpServer server) {
        this.registerIndexZPageHandler(server);
        this.registerTracezZPageHandler(server);
        this.registerTraceConfigzZPageHandler(server);
        ZPageLogo.registerStaticResources(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.server == null) {
                return;
            }
            this.server.stop(1);
            this.server = null;
        }
    }

    public SdkTracerProvider buildSdkTracerProvider() {
        return this.buildSdkTracerProvider(SdkTracerProvider.builder());
    }

    public SdkTracerProvider buildSdkTracerProvider(SdkTracerProviderBuilder builder) {
        return builder.addSpanProcessor(this.getSpanProcessor()).setSpanLimits(this.getTracezTraceConfigSupplier()).setSampler(this.getTracezSampler()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHttpServerAndRegisterAllPages(int port) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.server != null) {
                throw new IllegalStateException("The HttpServer is already started.");
            }
            this.server = HttpServer.create(new InetSocketAddress(port), 5);
            this.registerAllPagesToHttpServer(this.server);
            this.server.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ZPageServer.this.stop();
            }
        });
    }
}

