/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LoggerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MeterProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Resource;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TracerProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"file_format", "attribute_limits", "logger_provider", "meter_provider", "propagators", "tracer_provider", "resource"})
public class OpenTelemetryConfiguration {
    @JsonProperty(value="file_format")
    private String fileFormat;
    @JsonProperty(value="attribute_limits")
    private AttributeLimits attributeLimits;
    @JsonProperty(value="logger_provider")
    private LoggerProvider loggerProvider;
    @JsonProperty(value="meter_provider")
    private MeterProvider meterProvider;
    @JsonProperty(value="propagators")
    private List<String> propagators = new ArrayList<String>();
    @JsonProperty(value="tracer_provider")
    private TracerProvider tracerProvider;
    @JsonProperty(value="resource")
    private Resource resource;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="file_format")
    public String getFileFormat() {
        return this.fileFormat;
    }

    public OpenTelemetryConfiguration withFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @JsonProperty(value="attribute_limits")
    public AttributeLimits getAttributeLimits() {
        return this.attributeLimits;
    }

    public OpenTelemetryConfiguration withAttributeLimits(AttributeLimits attributeLimits) {
        this.attributeLimits = attributeLimits;
        return this;
    }

    @JsonProperty(value="logger_provider")
    public LoggerProvider getLoggerProvider() {
        return this.loggerProvider;
    }

    public OpenTelemetryConfiguration withLoggerProvider(LoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    @JsonProperty(value="meter_provider")
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public OpenTelemetryConfiguration withMeterProvider(MeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    @JsonProperty(value="propagators")
    public List<String> getPropagators() {
        return this.propagators;
    }

    public OpenTelemetryConfiguration withPropagators(List<String> propagators) {
        this.propagators = propagators;
        return this;
    }

    @JsonProperty(value="tracer_provider")
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public OpenTelemetryConfiguration withTracerProvider(TracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    @JsonProperty(value="resource")
    public Resource getResource() {
        return this.resource;
    }

    public OpenTelemetryConfiguration withResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OpenTelemetryConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenTelemetryConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(this.fileFormat == null ? "<null>" : this.fileFormat);
        sb.append(',');
        sb.append("attributeLimits");
        sb.append('=');
        sb.append(this.attributeLimits == null ? "<null>" : this.attributeLimits);
        sb.append(',');
        sb.append("loggerProvider");
        sb.append('=');
        sb.append(this.loggerProvider == null ? "<null>" : this.loggerProvider);
        sb.append(',');
        sb.append("meterProvider");
        sb.append('=');
        sb.append(this.meterProvider == null ? "<null>" : this.meterProvider);
        sb.append(',');
        sb.append("propagators");
        sb.append('=');
        sb.append(this.propagators == null ? "<null>" : this.propagators);
        sb.append(',');
        sb.append("tracerProvider");
        sb.append('=');
        sb.append(this.tracerProvider == null ? "<null>" : this.tracerProvider);
        sb.append(',');
        sb.append("resource");
        sb.append('=');
        sb.append(this.resource == null ? "<null>" : this.resource);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.attributeLimits == null ? 0 : this.attributeLimits.hashCode());
        result = result * 31 + (this.tracerProvider == null ? 0 : this.tracerProvider.hashCode());
        result = result * 31 + (this.resource == null ? 0 : this.resource.hashCode());
        result = result * 31 + (this.meterProvider == null ? 0 : this.meterProvider.hashCode());
        result = result * 31 + (this.propagators == null ? 0 : this.propagators.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        result = result * 31 + (this.loggerProvider == null ? 0 : this.loggerProvider.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenTelemetryConfiguration)) {
            return false;
        }
        OpenTelemetryConfiguration rhs = (OpenTelemetryConfiguration)other;
        return (this.attributeLimits == rhs.attributeLimits || this.attributeLimits != null && this.attributeLimits.equals(rhs.attributeLimits)) && (this.tracerProvider == rhs.tracerProvider || this.tracerProvider != null && this.tracerProvider.equals(rhs.tracerProvider)) && (this.resource == rhs.resource || this.resource != null && this.resource.equals(rhs.resource)) && (this.meterProvider == rhs.meterProvider || this.meterProvider != null && this.meterProvider.equals(rhs.meterProvider)) && (this.propagators == rhs.propagators || this.propagators != null && this.propagators.equals(rhs.propagators)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.fileFormat == rhs.fileFormat || this.fileFormat != null && this.fileFormat.equals(rhs.fileFormat)) && (this.loggerProvider == rhs.loggerProvider || this.loggerProvider != null && this.loggerProvider.equals(rhs.loggerProvider));
    }
}

