/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Aggregation;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "aggregation", "attribute_keys"})
public class Stream {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="aggregation")
    private Aggregation aggregation;
    @JsonProperty(value="attribute_keys")
    private List<String> attributeKeys = new ArrayList<String>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public Stream withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public Stream withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="aggregation")
    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public Stream withAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    @JsonProperty(value="attribute_keys")
    public List<String> getAttributeKeys() {
        return this.attributeKeys;
    }

    public Stream withAttributeKeys(List<String> attributeKeys) {
        this.attributeKeys = attributeKeys;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Stream.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("aggregation");
        sb.append('=');
        sb.append(this.aggregation == null ? "<null>" : this.aggregation);
        sb.append(',');
        sb.append("attributeKeys");
        sb.append('=');
        sb.append(this.attributeKeys == null ? "<null>" : this.attributeKeys);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.aggregation == null ? 0 : this.aggregation.hashCode());
        result = result * 31 + (this.attributeKeys == null ? 0 : this.attributeKeys.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Stream)) {
            return false;
        }
        Stream rhs = (Stream)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.aggregation == rhs.aggregation || this.aggregation != null && this.aggregation.equals(rhs.aggregation)) && (this.attributeKeys == rhs.attributeKeys || this.attributeKeys != null && this.attributeKeys.equals(rhs.attributeKeys));
    }
}

