/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordLimitsAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordLimits;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogLimitsBuilder;
import java.io.Closeable;
import java.util.List;
import javax.annotation.Nullable;

final class LogLimitsFactory
implements Factory<LogRecordLimitsAndAttributeLimits, LogLimits> {
    private static final LogLimitsFactory INSTANCE = new LogLimitsFactory();

    private LogLimitsFactory() {
    }

    static LogLimitsFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LogLimits create(@Nullable LogRecordLimitsAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        LogRecordLimits logRecordLimitsModel;
        if (model == null) {
            return LogLimits.getDefault();
        }
        LogLimitsBuilder builder = LogLimits.builder();
        AttributeLimits attributeLimitsModel = model.getAttributeLimits();
        if (attributeLimitsModel != null) {
            if (attributeLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(attributeLimitsModel.getAttributeCountLimit().intValue());
            }
            if (attributeLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(attributeLimitsModel.getAttributeValueLengthLimit().intValue());
            }
        }
        if ((logRecordLimitsModel = model.getLogRecordLimits()) != null) {
            if (logRecordLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(logRecordLimitsModel.getAttributeCountLimit().intValue());
            }
            if (logRecordLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(logRecordLimitsModel.getAttributeValueLengthLimit().intValue());
            }
        }
        return builder.build();
    }
}

