/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.JaegerRemote;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ParentBased;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Sampler;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TraceIdRatioBased;
import io.opentelemetry.sdk.trace.samplers.ParentBasedSamplerBuilder;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SamplerFactory
implements Factory<Sampler, io.opentelemetry.sdk.trace.samplers.Sampler> {
    private static final SamplerFactory INSTANCE = new SamplerFactory();

    private SamplerFactory() {
    }

    static SamplerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.samplers.Sampler create(@Nullable Sampler model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.sdk.trace.samplers.Sampler.parentBased((io.opentelemetry.sdk.trace.samplers.Sampler)io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn());
        }
        if (model.getAlwaysOn() != null) {
            return io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn();
        }
        if (model.getAlwaysOff() != null) {
            return io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOff();
        }
        TraceIdRatioBased traceIdRatioBasedModel = model.getTraceIdRatioBased();
        if (traceIdRatioBasedModel != null) {
            Double ratio = traceIdRatioBasedModel.getRatio();
            if (ratio == null) {
                ratio = 1.0;
            }
            return io.opentelemetry.sdk.trace.samplers.Sampler.traceIdRatioBased((double)ratio);
        }
        ParentBased parentBasedModel = model.getParentBased();
        if (parentBasedModel != null) {
            io.opentelemetry.sdk.trace.samplers.Sampler root = parentBasedModel.getRoot() == null ? io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn() : this.create(parentBasedModel.getRoot(), spiHelper, closeables);
            ParentBasedSamplerBuilder builder = io.opentelemetry.sdk.trace.samplers.Sampler.parentBasedBuilder((io.opentelemetry.sdk.trace.samplers.Sampler)root);
            if (parentBasedModel.getRemoteParentSampled() != null) {
                builder.setRemoteParentSampled(this.create(parentBasedModel.getRemoteParentSampled(), spiHelper, closeables));
            }
            if (parentBasedModel.getRemoteParentNotSampled() != null) {
                builder.setRemoteParentNotSampled(this.create(parentBasedModel.getRemoteParentNotSampled(), spiHelper, closeables));
            }
            if (parentBasedModel.getLocalParentSampled() != null) {
                builder.setLocalParentSampled(this.create(parentBasedModel.getLocalParentSampled(), spiHelper, closeables));
            }
            if (parentBasedModel.getLocalParentNotSampled() != null) {
                builder.setLocalParentNotSampled(this.create(parentBasedModel.getLocalParentNotSampled(), spiHelper, closeables));
            }
            return builder.build();
        }
        JaegerRemote jaegerRemoteModel = model.getJaegerRemote();
        if (jaegerRemoteModel != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (jaegerRemoteModel.getEndpoint() != null) {
                properties.put("endpoint", jaegerRemoteModel.getEndpoint());
            }
            if (jaegerRemoteModel.getInterval() != null) {
                properties.put("pollingInterval", String.valueOf(jaegerRemoteModel.getInterval()));
            }
            String otelTraceSamplerArg = properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            DefaultConfigProperties configProperties = DefaultConfigProperties.createFromMap(Collections.singletonMap("otel.traces.sampler.arg", otelTraceSamplerArg));
            return FileConfigUtil.addAndReturn(closeables, FileConfigUtil.assertNotNull((io.opentelemetry.sdk.trace.samplers.Sampler)SamplerFactory.samplerSpiManager((ConfigProperties)configProperties, spiHelper).getByName("jaeger_remote"), "jaeger remote sampler"));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized sampler(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return io.opentelemetry.sdk.trace.samplers.Sampler.parentBased((io.opentelemetry.sdk.trace.samplers.Sampler)io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn());
    }

    private static NamedSpiManager<io.opentelemetry.sdk.trace.samplers.Sampler> samplerSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableSamplerProvider.class, ConfigurableSamplerProvider::getName, ConfigurableSamplerProvider::createSampler, config);
    }
}

