/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Otlp;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class LogRecordExporterFactory
implements Factory<LogRecordExporter, io.opentelemetry.sdk.logs.export.LogRecordExporter> {
    private static final LogRecordExporterFactory INSTANCE = new LogRecordExporterFactory();

    private LogRecordExporterFactory() {
    }

    static LogRecordExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.logs.export.LogRecordExporter create(LogRecordExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        Otlp otlpModel = model.getOtlp();
        if (otlpModel != null) {
            model.getAdditionalProperties().put("otlp", otlpModel);
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple log record exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing exporter. This is a programming error."));
            io.opentelemetry.sdk.logs.export.LogRecordExporter logRecordExporter = FileConfigUtil.loadComponent(spiHelper, io.opentelemetry.sdk.logs.export.LogRecordExporter.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, logRecordExporter);
        }
        throw new ConfigurationException("log exporter must be set");
    }
}

