/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordExporterFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.BatchLogRecordProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class LogRecordProcessorFactory
implements Factory<LogRecordProcessor, io.opentelemetry.sdk.logs.LogRecordProcessor> {
    private static final LogRecordProcessorFactory INSTANCE = new LogRecordProcessorFactory();

    private LogRecordProcessorFactory() {
    }

    static LogRecordProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.logs.LogRecordProcessor create(LogRecordProcessor model, SpiHelper spiHelper, List<Closeable> closeables) {
        BatchLogRecordProcessor batchModel = model.getBatch();
        if (batchModel != null) {
            LogRecordExporter exporterModel = FileConfigUtil.requireNonNull(batchModel.getExporter(), "batch log record processor exporter");
            io.opentelemetry.sdk.logs.export.LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, spiHelper, closeables);
            BatchLogRecordProcessorBuilder builder = io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor.builder((io.opentelemetry.sdk.logs.export.LogRecordExporter)logRecordExporter);
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize().intValue());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize().intValue());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return (io.opentelemetry.sdk.logs.LogRecordProcessor)FileConfigUtil.addAndReturn(closeables, builder.build());
        }
        SimpleLogRecordProcessor simpleModel = model.getSimple();
        if (simpleModel != null) {
            LogRecordExporter exporterModel = FileConfigUtil.requireNonNull(simpleModel.getExporter(), "simple log record processor exporter");
            io.opentelemetry.sdk.logs.export.LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, spiHelper, closeables);
            return FileConfigUtil.addAndReturn(closeables, io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor.create((io.opentelemetry.sdk.logs.export.LogRecordExporter)logRecordExporter));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple log record processors set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry processorKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing processor. This is a programming error."));
            io.opentelemetry.sdk.logs.LogRecordProcessor logRecordProcessor = FileConfigUtil.loadComponent(spiHelper, io.opentelemetry.sdk.logs.LogRecordProcessor.class, (String)processorKeyValue.getKey(), processorKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, logRecordProcessor);
        }
        throw new ConfigurationException("log processor must be set");
    }
}

