/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.AttributesFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfiguration;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Attributes;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

final class ResourceFactory
implements Factory<Resource, io.opentelemetry.sdk.resources.Resource> {
    private static final StructuredConfigProperties EMPTY_CONFIG = FileConfiguration.toConfigProperties(Collections.emptyMap());
    private static final ResourceFactory INSTANCE = new ResourceFactory();

    private ResourceFactory() {
    }

    static ResourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.resources.Resource create(Resource model, SpiHelper spiHelper, List<Closeable> closeables) {
        io.opentelemetry.sdk.resources.Resource result = io.opentelemetry.sdk.resources.Resource.getDefault();
        List<io.opentelemetry.sdk.resources.Resource> resourceDetectorResources = ResourceFactory.loadFromResourceDetectors(spiHelper);
        for (io.opentelemetry.sdk.resources.Resource resourceProviderResource : resourceDetectorResources) {
            result = result.merge(resourceProviderResource);
        }
        Attributes attributesModel = model.getAttributes();
        if (attributesModel != null) {
            result = result.toBuilder().putAll(AttributesFactory.getInstance().create(attributesModel, spiHelper, closeables)).build();
        }
        return result;
    }

    private static List<io.opentelemetry.sdk.resources.Resource> loadFromResourceDetectors(SpiHelper spiHelper) {
        List componentProviders = spiHelper.load(ComponentProvider.class);
        ArrayList<ResourceAndOrder> resourceAndOrders = new ArrayList<ResourceAndOrder>();
        for (ComponentProvider componentProvider : componentProviders) {
            io.opentelemetry.sdk.resources.Resource resource;
            if (componentProvider.getType() != io.opentelemetry.sdk.resources.Resource.class) continue;
            try {
                resource = (io.opentelemetry.sdk.resources.Resource)componentProvider.create(EMPTY_CONFIG);
            }
            catch (Throwable throwable) {
                throw new ConfigurationException("Error configuring " + io.opentelemetry.sdk.resources.Resource.class.getName() + " with name \"" + componentProvider.getName() + "\"", throwable);
            }
            int order = componentProvider instanceof Ordered ? ((Ordered)componentProvider).order() : 0;
            resourceAndOrders.add(new ResourceAndOrder(resource, order));
        }
        resourceAndOrders.sort(Comparator.comparing(rec$ -> ((ResourceAndOrder)rec$).order()));
        return resourceAndOrders.stream().map(rec$ -> ((ResourceAndOrder)rec$).resource()).collect(Collectors.toList());
    }

    private static final class ResourceAndOrder {
        private final io.opentelemetry.sdk.resources.Resource resource;
        private final int order;

        private ResourceAndOrder(io.opentelemetry.sdk.resources.Resource resource, int order) {
            this.resource = resource;
            this.order = order;
        }

        private io.opentelemetry.sdk.resources.Resource resource() {
            return this.resource;
        }

        private int order() {
            return this.order;
        }
    }
}

