/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.JaegerRemote;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ParentBased;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Sampler;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TraceIdRatioBased;
import io.opentelemetry.sdk.trace.samplers.ParentBasedSamplerBuilder;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SamplerFactory
implements Factory<Sampler, io.opentelemetry.sdk.trace.samplers.Sampler> {
    private static final SamplerFactory INSTANCE = new SamplerFactory();

    private SamplerFactory() {
    }

    static SamplerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.samplers.Sampler create(Sampler model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model.getAlwaysOn() != null) {
            return io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn();
        }
        if (model.getAlwaysOff() != null) {
            return io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOff();
        }
        TraceIdRatioBased traceIdRatioBasedModel = model.getTraceIdRatioBased();
        if (traceIdRatioBasedModel != null) {
            Double ratio = traceIdRatioBasedModel.getRatio();
            if (ratio == null) {
                ratio = 1.0;
            }
            return io.opentelemetry.sdk.trace.samplers.Sampler.traceIdRatioBased((double)ratio);
        }
        ParentBased parentBasedModel = model.getParentBased();
        if (parentBasedModel != null) {
            io.opentelemetry.sdk.trace.samplers.Sampler sampler;
            io.opentelemetry.sdk.trace.samplers.Sampler root = parentBasedModel.getRoot() == null ? io.opentelemetry.sdk.trace.samplers.Sampler.alwaysOn() : this.create(parentBasedModel.getRoot(), spiHelper, closeables);
            ParentBasedSamplerBuilder builder = io.opentelemetry.sdk.trace.samplers.Sampler.parentBasedBuilder((io.opentelemetry.sdk.trace.samplers.Sampler)root);
            if (parentBasedModel.getRemoteParentSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentSampled(), spiHelper, closeables);
                builder.setRemoteParentSampled(sampler);
            }
            if (parentBasedModel.getRemoteParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentNotSampled(), spiHelper, closeables);
                builder.setRemoteParentNotSampled(sampler);
            }
            if (parentBasedModel.getLocalParentSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentSampled(), spiHelper, closeables);
                builder.setLocalParentSampled(sampler);
            }
            if (parentBasedModel.getLocalParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentNotSampled(), spiHelper, closeables);
                builder.setLocalParentNotSampled(sampler);
            }
            return builder.build();
        }
        JaegerRemote jaegerRemoteModel = model.getJaegerRemote();
        if (jaegerRemoteModel != null) {
            model.getAdditionalProperties().put("jaeger_remote", jaegerRemoteModel);
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple samplers exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing sampler. This is a programming error."));
            io.opentelemetry.sdk.trace.samplers.Sampler sampler = FileConfigUtil.loadComponent(spiHelper, io.opentelemetry.sdk.trace.samplers.Sampler.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, sampler);
        }
        throw new ConfigurationException("sampler must be set");
    }
}

