/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Otlp;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Zipkin;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SpanExporterFactory
implements Factory<SpanExporter, io.opentelemetry.sdk.trace.export.SpanExporter> {
    private static final SpanExporterFactory INSTANCE = new SpanExporterFactory();

    private SpanExporterFactory() {
    }

    static SpanExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.export.SpanExporter create(SpanExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        Zipkin zipkinModel;
        Otlp otlpModel = model.getOtlp();
        if (otlpModel != null) {
            model.getAdditionalProperties().put("otlp", otlpModel);
        }
        if (model.getConsole() != null) {
            model.getAdditionalProperties().put("console", model.getConsole());
        }
        if ((zipkinModel = model.getZipkin()) != null) {
            model.getAdditionalProperties().put("zipkin", model.getZipkin());
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple span exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing exporter. This is a programming error."));
            io.opentelemetry.sdk.trace.export.SpanExporter spanExporter = FileConfigUtil.loadComponent(spiHelper, io.opentelemetry.sdk.trace.export.SpanExporter.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, spanExporter);
        }
        throw new ConfigurationException("span exporter must be set");
    }
}

