
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Nullable;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * AttributeNameValue
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "value",
    "type"
})
@Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
public class AttributeNameValueModel {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    @Nonnull
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("value")
    @Nonnull
    private Object value;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("type")
    private AttributeNameValueModel.Type type;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    @Nullable
    public String getName() {
        return name;
    }

    public AttributeNameValueModel withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("value")
    @Nullable
    public Object getValue() {
        return value;
    }

    public AttributeNameValueModel withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty("type")
    public AttributeNameValueModel.Type getType() {
        return type;
    }

    public AttributeNameValueModel withType(AttributeNameValueModel.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AttributeNameValueModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AttributeNameValueModel) == false) {
            return false;
        }
        AttributeNameValueModel rhs = ((AttributeNameValueModel) other);
        return ((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
    public enum Type {

        STRING("string"),
        BOOL("bool"),
        INT("int"),
        DOUBLE("double"),
        STRING_ARRAY("string_array"),
        BOOL_ARRAY("bool_array"),
        INT_ARRAY("int_array"),
        DOUBLE_ARRAY("double_array");
        private final String value;
        private final static Map<String, AttributeNameValueModel.Type> CONSTANTS = new HashMap<String, AttributeNameValueModel.Type>();

        static {
            for (AttributeNameValueModel.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AttributeNameValueModel.Type fromValue(String value) {
            AttributeNameValueModel.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
