
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Nullable;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * OpenTelemetryConfiguration
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "file_format",
    "disabled",
    "attribute_limits",
    "logger_provider",
    "meter_provider",
    "propagator",
    "tracer_provider",
    "resource",
    "instrumentation"
})
@Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
public class OpenTelemetryConfigurationModel {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("file_format")
    @Nonnull
    private String fileFormat;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("disabled")
    private Boolean disabled;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("attribute_limits")
    private AttributeLimitsModel attributeLimits;
    /**
     * LoggerProvider
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("logger_provider")
    private LoggerProviderModel loggerProvider;
    /**
     * MeterProvider
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("meter_provider")
    private MeterProviderModel meterProvider;
    /**
     * Propagator
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("propagator")
    private PropagatorModel propagator;
    /**
     * TracerProvider
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("tracer_provider")
    private TracerProviderModel tracerProvider;
    /**
     * Resource
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("resource")
    private ResourceModel resource;
    /**
     * Instrumentation
     * <p>
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("instrumentation")
    private InstrumentationModel instrumentation;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("file_format")
    @Nullable
    public String getFileFormat() {
        return fileFormat;
    }

    public OpenTelemetryConfigurationModel withFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @JsonProperty("disabled")
    @Nullable
    public Boolean getDisabled() {
        return disabled;
    }

    public OpenTelemetryConfigurationModel withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @JsonProperty("attribute_limits")
    @Nullable
    public AttributeLimitsModel getAttributeLimits() {
        return attributeLimits;
    }

    public OpenTelemetryConfigurationModel withAttributeLimits(AttributeLimitsModel attributeLimits) {
        this.attributeLimits = attributeLimits;
        return this;
    }

    /**
     * LoggerProvider
     * <p>
     * 
     * 
     */
    @JsonProperty("logger_provider")
    @Nullable
    public LoggerProviderModel getLoggerProvider() {
        return loggerProvider;
    }

    public OpenTelemetryConfigurationModel withLoggerProvider(LoggerProviderModel loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    /**
     * MeterProvider
     * <p>
     * 
     * 
     */
    @JsonProperty("meter_provider")
    @Nullable
    public MeterProviderModel getMeterProvider() {
        return meterProvider;
    }

    public OpenTelemetryConfigurationModel withMeterProvider(MeterProviderModel meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    /**
     * Propagator
     * <p>
     * 
     * 
     */
    @JsonProperty("propagator")
    @Nullable
    public PropagatorModel getPropagator() {
        return propagator;
    }

    public OpenTelemetryConfigurationModel withPropagator(PropagatorModel propagator) {
        this.propagator = propagator;
        return this;
    }

    /**
     * TracerProvider
     * <p>
     * 
     * 
     */
    @JsonProperty("tracer_provider")
    @Nullable
    public TracerProviderModel getTracerProvider() {
        return tracerProvider;
    }

    public OpenTelemetryConfigurationModel withTracerProvider(TracerProviderModel tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    /**
     * Resource
     * <p>
     * 
     * 
     */
    @JsonProperty("resource")
    @Nullable
    public ResourceModel getResource() {
        return resource;
    }

    public OpenTelemetryConfigurationModel withResource(ResourceModel resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Instrumentation
     * <p>
     * 
     * 
     */
    @JsonProperty("instrumentation")
    @Nullable
    public InstrumentationModel getInstrumentation() {
        return instrumentation;
    }

    public OpenTelemetryConfigurationModel withInstrumentation(InstrumentationModel instrumentation) {
        this.instrumentation = instrumentation;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OpenTelemetryConfigurationModel withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenTelemetryConfigurationModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(((this.fileFormat == null)?"<null>":this.fileFormat));
        sb.append(',');
        sb.append("disabled");
        sb.append('=');
        sb.append(((this.disabled == null)?"<null>":this.disabled));
        sb.append(',');
        sb.append("attributeLimits");
        sb.append('=');
        sb.append(((this.attributeLimits == null)?"<null>":this.attributeLimits));
        sb.append(',');
        sb.append("loggerProvider");
        sb.append('=');
        sb.append(((this.loggerProvider == null)?"<null>":this.loggerProvider));
        sb.append(',');
        sb.append("meterProvider");
        sb.append('=');
        sb.append(((this.meterProvider == null)?"<null>":this.meterProvider));
        sb.append(',');
        sb.append("propagator");
        sb.append('=');
        sb.append(((this.propagator == null)?"<null>":this.propagator));
        sb.append(',');
        sb.append("tracerProvider");
        sb.append('=');
        sb.append(((this.tracerProvider == null)?"<null>":this.tracerProvider));
        sb.append(',');
        sb.append("resource");
        sb.append('=');
        sb.append(((this.resource == null)?"<null>":this.resource));
        sb.append(',');
        sb.append("instrumentation");
        sb.append('=');
        sb.append(((this.instrumentation == null)?"<null>":this.instrumentation));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.attributeLimits == null)? 0 :this.attributeLimits.hashCode()));
        result = ((result* 31)+((this.tracerProvider == null)? 0 :this.tracerProvider.hashCode()));
        result = ((result* 31)+((this.resource == null)? 0 :this.resource.hashCode()));
        result = ((result* 31)+((this.meterProvider == null)? 0 :this.meterProvider.hashCode()));
        result = ((result* 31)+((this.propagator == null)? 0 :this.propagator.hashCode()));
        result = ((result* 31)+((this.disabled == null)? 0 :this.disabled.hashCode()));
        result = ((result* 31)+((this.instrumentation == null)? 0 :this.instrumentation.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.fileFormat == null)? 0 :this.fileFormat.hashCode()));
        result = ((result* 31)+((this.loggerProvider == null)? 0 :this.loggerProvider.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OpenTelemetryConfigurationModel) == false) {
            return false;
        }
        OpenTelemetryConfigurationModel rhs = ((OpenTelemetryConfigurationModel) other);
        return (((((((((((this.attributeLimits == rhs.attributeLimits)||((this.attributeLimits!= null)&&this.attributeLimits.equals(rhs.attributeLimits)))&&((this.tracerProvider == rhs.tracerProvider)||((this.tracerProvider!= null)&&this.tracerProvider.equals(rhs.tracerProvider))))&&((this.resource == rhs.resource)||((this.resource!= null)&&this.resource.equals(rhs.resource))))&&((this.meterProvider == rhs.meterProvider)||((this.meterProvider!= null)&&this.meterProvider.equals(rhs.meterProvider))))&&((this.propagator == rhs.propagator)||((this.propagator!= null)&&this.propagator.equals(rhs.propagator))))&&((this.disabled == rhs.disabled)||((this.disabled!= null)&&this.disabled.equals(rhs.disabled))))&&((this.instrumentation == rhs.instrumentation)||((this.instrumentation!= null)&&this.instrumentation.equals(rhs.instrumentation))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.fileFormat == rhs.fileFormat)||((this.fileFormat!= null)&&this.fileFormat.equals(rhs.fileFormat))))&&((this.loggerProvider == rhs.loggerProvider)||((this.loggerProvider!= null)&&this.loggerProvider.equals(rhs.loggerProvider))));
    }

}
