/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.metric.viewconfig;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.metric.viewconfig.ViewConfig;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ViewConfigCustomizer
implements AutoConfigurationCustomizerProvider {
    public void customize(AutoConfigurationCustomizer autoConfiguration) {
        autoConfiguration.addMeterProviderCustomizer(ViewConfigCustomizer::customizeMeterProvider);
    }

    static SdkMeterProviderBuilder customizeMeterProvider(SdkMeterProviderBuilder meterProviderBuilder, ConfigProperties configProperties) {
        List configFileLocations = configProperties.getList("otel.experimental.metrics.view.config");
        for (String configFileLocation : configFileLocations) {
            if (configFileLocation.startsWith("classpath:")) {
                String classpathLocation = configFileLocation.substring("classpath:".length());
                try {
                    InputStream inputStream = ViewConfigCustomizer.class.getResourceAsStream(classpathLocation);
                    try {
                        if (inputStream == null) {
                            throw new ConfigurationException("Resource " + classpathLocation + " not found on classpath of classloader " + ViewConfigCustomizer.class.getClassLoader().getClass().getName());
                        }
                        ViewConfig.registerViews(meterProviderBuilder, inputStream);
                        continue;
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ConfigurationException("An error occurred reading view config resource on classpath: " + classpathLocation, (Throwable)e);
                }
            }
            try (FileInputStream fileInputStream = new FileInputStream(configFileLocation);){
                ViewConfig.registerViews(meterProviderBuilder, fileInputStream);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("View config file not found: " + configFileLocation, (Throwable)e);
            }
            catch (IOException e) {
                throw new ConfigurationException("An error occurred reading view config file: " + configFileLocation, (Throwable)e);
            }
        }
        return meterProviderBuilder;
    }
}

