/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class TextMapPropagatorFactory
implements Factory<List<String>, TextMapPropagator> {
    private static final TextMapPropagatorFactory INSTANCE = new TextMapPropagatorFactory();

    private TextMapPropagatorFactory() {
    }

    static TextMapPropagatorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public TextMapPropagator create(List<String> model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model.isEmpty()) {
            model = Arrays.asList("tracecontext", "baggage");
        }
        if (model.contains("none")) {
            if (model.size() > 1) {
                throw new ConfigurationException("propagators contains \"none\" along with other propagators");
            }
            return TextMapPropagator.noop();
        }
        ArrayList<TextMapPropagator> propagators = new ArrayList<TextMapPropagator>();
        for (String propagator : model) {
            propagators.add(TextMapPropagatorFactory.getPropagator(spiHelper, propagator));
        }
        return TextMapPropagator.composite(propagators);
    }

    private static TextMapPropagator getPropagator(SpiHelper spiHelper, String name) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        return FileConfigUtil.loadComponent(spiHelper, TextMapPropagator.class, name, Collections.emptyMap());
    }
}

