
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Nullable;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * OtlpMetric
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "protocol",
    "endpoint",
    "certificate",
    "client_key",
    "client_certificate",
    "headers",
    "headers_list",
    "compression",
    "timeout",
    "temporality_preference",
    "default_histogram_aggregation",
    "insecure"
})
@Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
public class OtlpMetricModel {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("protocol")
    @Nonnull
    private String protocol;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("endpoint")
    @Nonnull
    private String endpoint;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("certificate")
    private String certificate;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("client_key")
    private String clientKey;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("client_certificate")
    private String clientCertificate;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("headers")
    private List<NameStringValuePairModel> headers = new ArrayList<NameStringValuePairModel>();
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("headers_list")
    private String headersList;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("compression")
    private String compression;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("timeout")
    private Integer timeout;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("temporality_preference")
    private String temporalityPreference;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("default_histogram_aggregation")
    private OtlpMetricModel.DefaultHistogramAggregation defaultHistogramAggregation;
    /**
     * 
     * (Can be null)
     * 
     */
    @Nullable
    @JsonProperty("insecure")
    private Boolean insecure;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("protocol")
    @Nullable
    public String getProtocol() {
        return protocol;
    }

    public OtlpMetricModel withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("endpoint")
    @Nullable
    public String getEndpoint() {
        return endpoint;
    }

    public OtlpMetricModel withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty("certificate")
    @Nullable
    public String getCertificate() {
        return certificate;
    }

    public OtlpMetricModel withCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @JsonProperty("client_key")
    @Nullable
    public String getClientKey() {
        return clientKey;
    }

    public OtlpMetricModel withClientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @JsonProperty("client_certificate")
    @Nullable
    public String getClientCertificate() {
        return clientCertificate;
    }

    public OtlpMetricModel withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    @JsonProperty("headers")
    public List<NameStringValuePairModel> getHeaders() {
        return headers;
    }

    public OtlpMetricModel withHeaders(List<NameStringValuePairModel> headers) {
        this.headers = headers;
        return this;
    }

    @JsonProperty("headers_list")
    @Nullable
    public String getHeadersList() {
        return headersList;
    }

    public OtlpMetricModel withHeadersList(String headersList) {
        this.headersList = headersList;
        return this;
    }

    @JsonProperty("compression")
    @Nullable
    public String getCompression() {
        return compression;
    }

    public OtlpMetricModel withCompression(String compression) {
        this.compression = compression;
        return this;
    }

    @JsonProperty("timeout")
    @Nullable
    public Integer getTimeout() {
        return timeout;
    }

    public OtlpMetricModel withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty("temporality_preference")
    @Nullable
    public String getTemporalityPreference() {
        return temporalityPreference;
    }

    public OtlpMetricModel withTemporalityPreference(String temporalityPreference) {
        this.temporalityPreference = temporalityPreference;
        return this;
    }

    @JsonProperty("default_histogram_aggregation")
    public OtlpMetricModel.DefaultHistogramAggregation getDefaultHistogramAggregation() {
        return defaultHistogramAggregation;
    }

    public OtlpMetricModel withDefaultHistogramAggregation(OtlpMetricModel.DefaultHistogramAggregation defaultHistogramAggregation) {
        this.defaultHistogramAggregation = defaultHistogramAggregation;
        return this;
    }

    @JsonProperty("insecure")
    @Nullable
    public Boolean getInsecure() {
        return insecure;
    }

    public OtlpMetricModel withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OtlpMetricModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("protocol");
        sb.append('=');
        sb.append(((this.protocol == null)?"<null>":this.protocol));
        sb.append(',');
        sb.append("endpoint");
        sb.append('=');
        sb.append(((this.endpoint == null)?"<null>":this.endpoint));
        sb.append(',');
        sb.append("certificate");
        sb.append('=');
        sb.append(((this.certificate == null)?"<null>":this.certificate));
        sb.append(',');
        sb.append("clientKey");
        sb.append('=');
        sb.append(((this.clientKey == null)?"<null>":this.clientKey));
        sb.append(',');
        sb.append("clientCertificate");
        sb.append('=');
        sb.append(((this.clientCertificate == null)?"<null>":this.clientCertificate));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("headersList");
        sb.append('=');
        sb.append(((this.headersList == null)?"<null>":this.headersList));
        sb.append(',');
        sb.append("compression");
        sb.append('=');
        sb.append(((this.compression == null)?"<null>":this.compression));
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(((this.timeout == null)?"<null>":this.timeout));
        sb.append(',');
        sb.append("temporalityPreference");
        sb.append('=');
        sb.append(((this.temporalityPreference == null)?"<null>":this.temporalityPreference));
        sb.append(',');
        sb.append("defaultHistogramAggregation");
        sb.append('=');
        sb.append(((this.defaultHistogramAggregation == null)?"<null>":this.defaultHistogramAggregation));
        sb.append(',');
        sb.append("insecure");
        sb.append('=');
        sb.append(((this.insecure == null)?"<null>":this.insecure));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.clientCertificate == null)? 0 :this.clientCertificate.hashCode()));
        result = ((result* 31)+((this.certificate == null)? 0 :this.certificate.hashCode()));
        result = ((result* 31)+((this.timeout == null)? 0 :this.timeout.hashCode()));
        result = ((result* 31)+((this.defaultHistogramAggregation == null)? 0 :this.defaultHistogramAggregation.hashCode()));
        result = ((result* 31)+((this.protocol == null)? 0 :this.protocol.hashCode()));
        result = ((result* 31)+((this.endpoint == null)? 0 :this.endpoint.hashCode()));
        result = ((result* 31)+((this.clientKey == null)? 0 :this.clientKey.hashCode()));
        result = ((result* 31)+((this.headersList == null)? 0 :this.headersList.hashCode()));
        result = ((result* 31)+((this.insecure == null)? 0 :this.insecure.hashCode()));
        result = ((result* 31)+((this.compression == null)? 0 :this.compression.hashCode()));
        result = ((result* 31)+((this.temporalityPreference == null)? 0 :this.temporalityPreference.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OtlpMetricModel) == false) {
            return false;
        }
        OtlpMetricModel rhs = ((OtlpMetricModel) other);
        return (((((((((((((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers)))&&((this.clientCertificate == rhs.clientCertificate)||((this.clientCertificate!= null)&&this.clientCertificate.equals(rhs.clientCertificate))))&&((this.certificate == rhs.certificate)||((this.certificate!= null)&&this.certificate.equals(rhs.certificate))))&&((this.timeout == rhs.timeout)||((this.timeout!= null)&&this.timeout.equals(rhs.timeout))))&&((this.defaultHistogramAggregation == rhs.defaultHistogramAggregation)||((this.defaultHistogramAggregation!= null)&&this.defaultHistogramAggregation.equals(rhs.defaultHistogramAggregation))))&&((this.protocol == rhs.protocol)||((this.protocol!= null)&&this.protocol.equals(rhs.protocol))))&&((this.endpoint == rhs.endpoint)||((this.endpoint!= null)&&this.endpoint.equals(rhs.endpoint))))&&((this.clientKey == rhs.clientKey)||((this.clientKey!= null)&&this.clientKey.equals(rhs.clientKey))))&&((this.headersList == rhs.headersList)||((this.headersList!= null)&&this.headersList.equals(rhs.headersList))))&&((this.insecure == rhs.insecure)||((this.insecure!= null)&&this.insecure.equals(rhs.insecure))))&&((this.compression == rhs.compression)||((this.compression!= null)&&this.compression.equals(rhs.compression))))&&((this.temporalityPreference == rhs.temporalityPreference)||((this.temporalityPreference!= null)&&this.temporalityPreference.equals(rhs.temporalityPreference))));
    }

    @Generated("jsonschema2pojo")
@SuppressWarnings("rawtypes")
    public enum DefaultHistogramAggregation {

        EXPLICIT_BUCKET_HISTOGRAM("explicit_bucket_histogram"),
        BASE_2_EXPONENTIAL_BUCKET_HISTOGRAM("base2_exponential_bucket_histogram");
        private final String value;
        private final static Map<String, OtlpMetricModel.DefaultHistogramAggregation> CONSTANTS = new HashMap<String, OtlpMetricModel.DefaultHistogramAggregation>();

        static {
            for (OtlpMetricModel.DefaultHistogramAggregation c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DefaultHistogramAggregation(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OtlpMetricModel.DefaultHistogramAggregation fromValue(String value) {
            OtlpMetricModel.DefaultHistogramAggregation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
