/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.InstrumentSelectorFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.MetricReaderFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.ViewFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MeterProviderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SelectorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.StreamModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ViewModel;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import java.io.Closeable;
import java.util.List;

final class MeterProviderFactory
implements Factory<MeterProviderModel, SdkMeterProviderBuilder> {
    private static final MeterProviderFactory INSTANCE = new MeterProviderFactory();

    private MeterProviderFactory() {
    }

    static MeterProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkMeterProviderBuilder create(MeterProviderModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        List<ViewModel> viewModels;
        SdkMeterProviderBuilder builder = SdkMeterProvider.builder();
        List<MetricReaderModel> readerModels = model.getReaders();
        if (readerModels != null) {
            readerModels.forEach(readerModel -> {
                MetricReader metricReader = MetricReaderFactory.getInstance().create((MetricReaderModel)readerModel, spiHelper, closeables);
                if (metricReader != null) {
                    builder.registerMetricReader(metricReader);
                }
            });
        }
        if ((viewModels = model.getViews()) != null) {
            viewModels.forEach(viewModel -> {
                SelectorModel selector = FileConfigUtil.requireNonNull(viewModel.getSelector(), "view selector");
                StreamModel stream = FileConfigUtil.requireNonNull(viewModel.getStream(), "view stream");
                builder.registerView(InstrumentSelectorFactory.getInstance().create(selector, spiHelper, closeables), ViewFactory.getInstance().create(stream, spiHelper, closeables));
            });
        }
        return builder;
    }
}

