/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationBuilder;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.OpenTelemetryConfigurationFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.SamplerFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.YamlDeclarativeConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SamplerModel;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.constructor.BaseConstructor;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.schema.CoreSchema;
import org.snakeyaml.engine.v2.schema.Schema;

public final class DeclarativeConfiguration {
    private static final Logger logger = Logger.getLogger(DeclarativeConfiguration.class.getName());
    private static final Pattern ENV_VARIABLE_REFERENCE = Pattern.compile("\\$\\{([a-zA-Z_][a-zA-Z0-9_]*)(:-([^\n}]*))?}");
    private static final ComponentLoader DEFAULT_COMPONENT_LOADER = SpiHelper.serviceComponentLoader((ClassLoader)DeclarativeConfiguration.class.getClassLoader());
    private static final ObjectMapper MAPPER = new ObjectMapper().setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));

    private DeclarativeConfiguration() {
    }

    public static OpenTelemetrySdk parseAndCreate(InputStream inputStream) {
        OpenTelemetryConfigurationModel configurationModel = DeclarativeConfiguration.parse(inputStream);
        return DeclarativeConfiguration.create(configurationModel);
    }

    public static OpenTelemetrySdk create(OpenTelemetryConfigurationModel configurationModel) {
        return DeclarativeConfiguration.create(configurationModel, DEFAULT_COMPONENT_LOADER);
    }

    public static OpenTelemetrySdk create(OpenTelemetryConfigurationModel configurationModel, ComponentLoader componentLoader) {
        SpiHelper spiHelper = SpiHelper.create((ComponentLoader)componentLoader);
        DeclarativeConfigurationBuilder builder = new DeclarativeConfigurationBuilder();
        for (DeclarativeConfigurationCustomizerProvider provider : spiHelper.loadOrdered(DeclarativeConfigurationCustomizerProvider.class)) {
            provider.customize(builder);
        }
        return DeclarativeConfiguration.createAndMaybeCleanup(OpenTelemetryConfigurationFactory.getInstance(), spiHelper, builder.customizeModel(configurationModel));
    }

    public static OpenTelemetryConfigurationModel parse(InputStream configuration) {
        try {
            return DeclarativeConfiguration.parse(configuration, System.getenv());
        }
        catch (RuntimeException e) {
            throw new DeclarativeConfigException("Unable to parse configuration input stream", (Throwable)e);
        }
    }

    static OpenTelemetryConfigurationModel parse(InputStream configuration, Map<String, String> environmentVariables) {
        Object yamlObj = DeclarativeConfiguration.loadYaml(configuration, environmentVariables);
        return (OpenTelemetryConfigurationModel)MAPPER.convertValue(yamlObj, OpenTelemetryConfigurationModel.class);
    }

    static Object loadYaml(InputStream inputStream, Map<String, String> environmentVariables) {
        LoadSettings settings = LoadSettings.builder().setSchema((Schema)new CoreSchema()).build();
        Load yaml = new Load(settings, (BaseConstructor)new EnvSubstitutionConstructor(settings, environmentVariables));
        return yaml.loadFromInputStream(inputStream);
    }

    public static DeclarativeConfigProperties toConfigProperties(OpenTelemetryConfigurationModel model) {
        return DeclarativeConfiguration.toConfigProperties(model, DEFAULT_COMPONENT_LOADER);
    }

    public static DeclarativeConfigProperties toConfigProperties(InputStream configuration) {
        Object yamlObj = DeclarativeConfiguration.loadYaml(configuration, System.getenv());
        return DeclarativeConfiguration.toConfigProperties(yamlObj, DEFAULT_COMPONENT_LOADER);
    }

    static DeclarativeConfigProperties toConfigProperties(Object model, ComponentLoader componentLoader) {
        Map<String, Object> configurationMap = (Map<String, Object>)MAPPER.convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (configurationMap == null) {
            configurationMap = Collections.emptyMap();
        }
        return YamlDeclarativeConfigProperties.create(configurationMap, componentLoader);
    }

    public static Sampler createSampler(DeclarativeConfigProperties genericSamplerModel) {
        YamlDeclarativeConfigProperties yamlDeclarativeConfigProperties = DeclarativeConfiguration.requireYamlDeclarativeConfigProperties(genericSamplerModel);
        SamplerModel samplerModel = DeclarativeConfiguration.convertToModel(yamlDeclarativeConfigProperties, SamplerModel.class);
        return DeclarativeConfiguration.createAndMaybeCleanup(SamplerFactory.getInstance(), SpiHelper.create((ComponentLoader)yamlDeclarativeConfigProperties.getComponentLoader()), samplerModel);
    }

    private static YamlDeclarativeConfigProperties requireYamlDeclarativeConfigProperties(DeclarativeConfigProperties declarativeConfigProperties) {
        if (!(declarativeConfigProperties instanceof YamlDeclarativeConfigProperties)) {
            throw new DeclarativeConfigException("Only YamlDeclarativeConfigProperties can be converted to model");
        }
        return (YamlDeclarativeConfigProperties)declarativeConfigProperties;
    }

    static <T> T convertToModel(YamlDeclarativeConfigProperties yamlDeclarativeConfigProperties, Class<T> modelType) {
        return (T)MAPPER.convertValue(yamlDeclarativeConfigProperties.toMap(), modelType);
    }

    static <M, R> R createAndMaybeCleanup(Factory<M, R> factory, SpiHelper spiHelper, M model) {
        DeclarativeConfigContext context = new DeclarativeConfigContext(spiHelper);
        try {
            return factory.create(model, context);
        }
        catch (RuntimeException e) {
            logger.info("Error encountered interpreting model. Closing partially configured components.");
            for (Closeable closeable : context.getCloseables()) {
                try {
                    logger.fine("Closing " + closeable.getClass().getName());
                    closeable.close();
                }
                catch (IOException ex) {
                    logger.warning("Error closing " + closeable.getClass().getName() + ": " + ex.getMessage());
                }
            }
            if (e instanceof DeclarativeConfigException) {
                throw e;
            }
            throw new DeclarativeConfigException("Unexpected configuration error", (Throwable)e);
        }
    }

    static {
        MAPPER.configOverride(String.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Integer.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Double.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Boolean.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
    }

    private static final class EnvSubstitutionConstructor
    extends StandardConstructor {
        private final Load load;
        private final Map<String, String> environmentVariables;
        private static final String ESCAPE_SEQUENCE = "$$";
        private static final int ESCAPE_SEQUENCE_LENGTH = "$$".length();
        private static final char ESCAPE_SEQUENCE_REPLACEMENT = '$';

        private EnvSubstitutionConstructor(LoadSettings loadSettings, Map<String, String> environmentVariables) {
            super(loadSettings);
            this.load = new Load(loadSettings);
            this.environmentVariables = environmentVariables;
        }

        protected Map<Object, Object> constructMapping(MappingNode node) {
            Map mapping = (Map)this.settings.getDefaultMap().apply(node.getValue().size());
            List nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                Node keyNode = tuple.getKeyNode();
                Object key = this.constructObject(keyNode);
                if (key != null) {
                    try {
                        key.hashCode();
                    }
                    catch (Exception e) {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), (Throwable)e);
                    }
                }
                Node valueNode = tuple.getValueNode();
                Object value = this.constructValueObject(valueNode);
                if (keyNode.isRecursive()) {
                    if (this.settings.getAllowRecursiveKeys()) {
                        this.postponeMapFilling(mapping, key, value);
                        continue;
                    }
                    throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
                }
                mapping.put(key, value);
            }
            return mapping;
        }

        private Object constructValueObject(Node node) {
            int escapeIndex;
            Object value = this.constructObject(node);
            if (!(node instanceof ScalarNode)) {
                return value;
            }
            if (!(value instanceof String)) {
                return value;
            }
            String val = (String)value;
            ScalarStyle scalarStyle = ((ScalarNode)node).getScalarStyle();
            int lastEscapeIndexEnd = 0;
            StringBuilder newVal = null;
            do {
                int substitutionEndIndex = (escapeIndex = val.indexOf(ESCAPE_SEQUENCE, lastEscapeIndexEnd)) == -1 ? val.length() : escapeIndex;
                newVal = this.envVarSubstitution(newVal, val, lastEscapeIndexEnd, substitutionEndIndex);
                if (escapeIndex == -1) break;
                newVal.append('$');
            } while ((lastEscapeIndexEnd = escapeIndex + ESCAPE_SEQUENCE_LENGTH) < val.length());
            if (scalarStyle == ScalarStyle.DOUBLE_QUOTED) {
                newVal.insert(0, "\"");
                newVal.append("\"");
            }
            return this.load.loadFromString(newVal.toString());
        }

        private StringBuilder envVarSubstitution(@Nullable StringBuilder newVal, String source, int startIndex, int endIndex) {
            String val = source.substring(startIndex, endIndex);
            Matcher matcher = ENV_VARIABLE_REFERENCE.matcher(val);
            if (!matcher.find()) {
                return newVal == null ? new StringBuilder(val) : newVal.append(val);
            }
            if (newVal == null) {
                newVal = new StringBuilder();
            }
            int offset = 0;
            do {
                MatchResult matchResult = matcher.toMatchResult();
                String envVarKey = matcher.group(1);
                String defaultValue = matcher.group(3);
                if (defaultValue == null) {
                    defaultValue = "";
                }
                String replacement = this.environmentVariables.getOrDefault(envVarKey, defaultValue);
                newVal.append(val, offset, matchResult.start()).append(replacement);
                offset = matchResult.end();
            } while (matcher.find());
            if (offset != val.length()) {
                newVal.append(val, offset, val.length());
            }
            return newVal;
        }
    }
}

