/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationBuilder;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.OpenTelemetryConfigurationFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.SamplerFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.YamlDeclarativeConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SamplerModel;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;
import org.snakeyaml.engine.v2.scanner.StreamReader;
import org.snakeyaml.engine.v2.schema.CoreSchema;
import org.snakeyaml.engine.v2.schema.Schema;

public final class DeclarativeConfiguration {
    private static final Logger logger = Logger.getLogger(DeclarativeConfiguration.class.getName());
    private static final Pattern ENV_VARIABLE_REFERENCE = Pattern.compile("\\$\\{([a-zA-Z_][a-zA-Z0-9_]*)(:-([^\n}]*))?}");
    private static final ComponentLoader DEFAULT_COMPONENT_LOADER = ComponentLoader.forClassLoader((ClassLoader)DeclarativeConfigProperties.class.getClassLoader());
    static final ObjectMapper MAPPER = new ObjectMapper().setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));

    private DeclarativeConfiguration() {
    }

    public static OpenTelemetrySdk parseAndCreate(InputStream inputStream) {
        OpenTelemetryConfigurationModel configurationModel = DeclarativeConfiguration.parse(inputStream);
        return DeclarativeConfiguration.create(configurationModel);
    }

    public static OpenTelemetrySdk create(OpenTelemetryConfigurationModel configurationModel) {
        return DeclarativeConfiguration.create(configurationModel, DEFAULT_COMPONENT_LOADER);
    }

    public static OpenTelemetrySdk create(OpenTelemetryConfigurationModel configurationModel, ComponentLoader componentLoader) {
        SpiHelper spiHelper = SpiHelper.create((ComponentLoader)componentLoader);
        DeclarativeConfigurationBuilder builder = new DeclarativeConfigurationBuilder();
        for (DeclarativeConfigurationCustomizerProvider provider : spiHelper.loadOrdered(DeclarativeConfigurationCustomizerProvider.class)) {
            provider.customize(builder);
        }
        return DeclarativeConfiguration.createAndMaybeCleanup(OpenTelemetryConfigurationFactory.getInstance(), spiHelper, builder.customizeModel(configurationModel));
    }

    public static OpenTelemetryConfigurationModel parse(InputStream configuration) {
        try {
            return DeclarativeConfiguration.parse(configuration, System.getenv());
        }
        catch (RuntimeException e) {
            throw new DeclarativeConfigException("Unable to parse configuration input stream", (Throwable)e);
        }
    }

    static OpenTelemetryConfigurationModel parse(InputStream configuration, Map<String, String> environmentVariables) {
        Object yamlObj = DeclarativeConfiguration.loadYaml(configuration, environmentVariables);
        return (OpenTelemetryConfigurationModel)MAPPER.convertValue(yamlObj, OpenTelemetryConfigurationModel.class);
    }

    static Object loadYaml(InputStream inputStream, Map<String, String> environmentVariables) {
        LoadSettings settings = LoadSettings.builder().setSchema((Schema)new CoreSchema()).build();
        EnvLoad yaml = new EnvLoad(settings, environmentVariables);
        return yaml.loadFromInputStream(inputStream);
    }

    public static DeclarativeConfigProperties toConfigProperties(Object model) {
        return DeclarativeConfiguration.toConfigProperties(model, DEFAULT_COMPONENT_LOADER);
    }

    public static DeclarativeConfigProperties toConfigProperties(InputStream configuration) {
        Object yamlObj = DeclarativeConfiguration.loadYaml(configuration, System.getenv());
        return DeclarativeConfiguration.toConfigProperties(yamlObj, DEFAULT_COMPONENT_LOADER);
    }

    static DeclarativeConfigProperties toConfigProperties(Object model, ComponentLoader componentLoader) {
        Map<String, Object> configurationMap = (Map<String, Object>)MAPPER.convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (configurationMap == null) {
            configurationMap = Collections.emptyMap();
        }
        return YamlDeclarativeConfigProperties.create(configurationMap, componentLoader);
    }

    public static Sampler createSampler(DeclarativeConfigProperties genericSamplerModel) {
        YamlDeclarativeConfigProperties yamlDeclarativeConfigProperties = DeclarativeConfiguration.requireYamlDeclarativeConfigProperties(genericSamplerModel);
        SamplerModel samplerModel = (SamplerModel)MAPPER.convertValue((Object)DeclarativeConfigProperties.toMap((DeclarativeConfigProperties)yamlDeclarativeConfigProperties), SamplerModel.class);
        return DeclarativeConfiguration.createAndMaybeCleanup(SamplerFactory.getInstance(), SpiHelper.create((ComponentLoader)yamlDeclarativeConfigProperties.getComponentLoader()), samplerModel);
    }

    private static YamlDeclarativeConfigProperties requireYamlDeclarativeConfigProperties(DeclarativeConfigProperties declarativeConfigProperties) {
        if (!(declarativeConfigProperties instanceof YamlDeclarativeConfigProperties)) {
            throw new DeclarativeConfigException("Only YamlDeclarativeConfigProperties can be converted to model");
        }
        return (YamlDeclarativeConfigProperties)declarativeConfigProperties;
    }

    static <M, R> R createAndMaybeCleanup(Factory<M, R> factory, SpiHelper spiHelper, M model) {
        DeclarativeConfigContext context = new DeclarativeConfigContext(spiHelper);
        try {
            return factory.create(model, context);
        }
        catch (RuntimeException e) {
            logger.info("Error encountered interpreting model. Closing partially configured components.");
            for (Closeable closeable : context.getCloseables()) {
                try {
                    logger.fine("Closing " + closeable.getClass().getName());
                    closeable.close();
                }
                catch (IOException ex) {
                    logger.warning("Error closing " + closeable.getClass().getName() + ": " + ex.getMessage());
                }
            }
            if (e instanceof DeclarativeConfigException) {
                throw e;
            }
            throw new DeclarativeConfigException("Unexpected configuration error", (Throwable)e);
        }
    }

    static {
        MAPPER.configOverride(String.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Integer.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Double.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Boolean.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
    }

    private static final class EnvLoad
    extends Load {
        private final LoadSettings settings;
        private final Map<String, String> environmentVariables;

        public EnvLoad(LoadSettings settings, Map<String, String> environmentVariables) {
            super(settings);
            this.settings = settings;
            this.environmentVariables = environmentVariables;
        }

        public Object loadFromInputStream(InputStream yamlStream) {
            Objects.requireNonNull(yamlStream, "InputStream cannot be null");
            return this.loadOne(new EnvComposer(this.settings, new ParserImpl(this.settings, new StreamReader(this.settings, (Reader)new YamlUnicodeReader(yamlStream))), this.environmentVariables));
        }
    }

    private static final class EnvComposer
    extends Composer {
        private final Load load;
        private final Map<String, String> environmentVariables;
        private final ScalarResolver scalarResolver;
        private static final String ESCAPE_SEQUENCE = "$$";
        private static final int ESCAPE_SEQUENCE_LENGTH = "$$".length();
        private static final char ESCAPE_SEQUENCE_REPLACEMENT = '$';

        public EnvComposer(LoadSettings settings, ParserImpl parser, Map<String, String> environmentVariables) {
            super(settings, (Parser)parser);
            this.load = new Load(settings);
            this.environmentVariables = environmentVariables;
            this.scalarResolver = settings.getSchema().getScalarResolver();
        }

        protected Node composeValueNode(MappingNode node) {
            Tag resolvedTag;
            Node itemValue = super.composeValueNode(node);
            if (!(itemValue instanceof ScalarNode)) {
                return itemValue;
            }
            ScalarNode scalarNode = (ScalarNode)itemValue;
            String envSubstitution = this.envSubstitution(scalarNode.getValue());
            if (envSubstitution.equals(scalarNode.getValue())) {
                return itemValue;
            }
            Object envSubstitutionObj = this.load.loadFromString(envSubstitution);
            Tag tag = itemValue.getTag();
            ScalarStyle scalarStyle = scalarNode.getScalarStyle();
            Tag tag2 = resolvedTag = envSubstitutionObj == null ? Tag.NULL : this.scalarResolver.resolve(envSubstitutionObj.toString(), Boolean.valueOf(true));
            if (!itemValue.getTag().equals((Object)resolvedTag) && scalarStyle != ScalarStyle.SINGLE_QUOTED && scalarStyle != ScalarStyle.DOUBLE_QUOTED) {
                tag = resolvedTag;
            }
            boolean resolved = true;
            return new ScalarNode(tag, resolved, envSubstitution, scalarStyle, itemValue.getStartMark(), itemValue.getEndMark());
        }

        private String envSubstitution(String val) {
            int escapeIndex;
            int lastEscapeIndexEnd = 0;
            StringBuilder newVal = null;
            do {
                int substitutionEndIndex = (escapeIndex = val.indexOf(ESCAPE_SEQUENCE, lastEscapeIndexEnd)) == -1 ? val.length() : escapeIndex;
                newVal = this.envVarSubstitution(newVal, val, lastEscapeIndexEnd, substitutionEndIndex);
                if (escapeIndex == -1) break;
                newVal.append('$');
            } while ((lastEscapeIndexEnd = escapeIndex + ESCAPE_SEQUENCE_LENGTH) < val.length());
            return newVal.toString();
        }

        private StringBuilder envVarSubstitution(@Nullable StringBuilder newVal, String source, int startIndex, int endIndex) {
            String val = source.substring(startIndex, endIndex);
            Matcher matcher = ENV_VARIABLE_REFERENCE.matcher(val);
            if (!matcher.find()) {
                return newVal == null ? new StringBuilder(val) : newVal.append(val);
            }
            if (newVal == null) {
                newVal = new StringBuilder();
            }
            int offset = 0;
            do {
                MatchResult matchResult = matcher.toMatchResult();
                String envVarKey = matcher.group(1);
                String defaultValue = matcher.group(3);
                if (defaultValue == null) {
                    defaultValue = "";
                }
                String replacement = this.environmentVariables.getOrDefault(envVarKey, defaultValue);
                newVal.append(val, offset, matchResult.start()).append(replacement);
                offset = matchResult.end();
            } while (matcher.find());
            if (offset != val.length()) {
                newVal.append(val, offset, val.length());
            }
            return newVal;
        }
    }
}

