/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordExporterFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.BatchLogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleLogRecordProcessorModel;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import java.time.Duration;
import java.util.Map;

final class LogRecordProcessorFactory
implements Factory<LogRecordProcessorModel, LogRecordProcessor> {
    private static final LogRecordProcessorFactory INSTANCE = new LogRecordProcessorFactory();

    private LogRecordProcessorFactory() {
    }

    static LogRecordProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LogRecordProcessor create(LogRecordProcessorModel model, DeclarativeConfigContext context) {
        BatchLogRecordProcessorModel batchModel = model.getBatch();
        if (batchModel != null) {
            LogRecordExporterModel exporterModel = FileConfigUtil.requireNonNull(batchModel.getExporter(), "batch log record processor exporter");
            LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, context);
            BatchLogRecordProcessorBuilder builder = BatchLogRecordProcessor.builder((LogRecordExporter)logRecordExporter);
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize().intValue());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize().intValue());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return (LogRecordProcessor)context.addCloseable(builder.build());
        }
        SimpleLogRecordProcessorModel simpleModel = model.getSimple();
        if (simpleModel != null) {
            LogRecordExporterModel exporterModel = FileConfigUtil.requireNonNull(simpleModel.getExporter(), "simple log record processor exporter");
            LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, context);
            return context.addCloseable(SimpleLogRecordProcessor.create((LogRecordExporter)logRecordExporter));
        }
        Map.Entry<String, Object> keyValue = FileConfigUtil.getSingletonMapEntry(model.getAdditionalProperties(), "log record processor");
        LogRecordProcessor logRecordProcessor = context.loadComponent(LogRecordProcessor.class, keyValue.getKey(), keyValue.getValue());
        return context.addCloseable(logRecordProcessor);
    }
}

