/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.CardinalityLimitsModel;
import io.opentelemetry.sdk.metrics.export.CardinalityLimitSelector;
import javax.annotation.Nullable;

final class CardinalityLimitsFactory
implements Factory<CardinalityLimitsModel, CardinalityLimitSelector> {
    private static final CardinalityLimitsFactory INSTANCE = new CardinalityLimitsFactory();

    private CardinalityLimitsFactory() {
    }

    static CardinalityLimitsFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public CardinalityLimitSelector create(CardinalityLimitsModel model, DeclarativeConfigContext context) {
        int defaultLimit = CardinalityLimitsFactory.getOrDefault(model.getDefault(), 2000);
        int counterLimit = CardinalityLimitsFactory.getOrDefault(model.getCounter(), defaultLimit);
        int gaugeLimit = CardinalityLimitsFactory.getOrDefault(model.getGauge(), defaultLimit);
        int histogramLimit = CardinalityLimitsFactory.getOrDefault(model.getHistogram(), defaultLimit);
        int observableCounterLimit = CardinalityLimitsFactory.getOrDefault(model.getObservableCounter(), defaultLimit);
        int observableGaugeLimit = CardinalityLimitsFactory.getOrDefault(model.getObservableGauge(), defaultLimit);
        int observableUpDownCounterLimit = CardinalityLimitsFactory.getOrDefault(model.getObservableUpDownCounter(), defaultLimit);
        int upDownCounterLimit = CardinalityLimitsFactory.getOrDefault(model.getUpDownCounter(), defaultLimit);
        return instrumentType -> {
            switch (instrumentType) {
                case COUNTER: {
                    return counterLimit;
                }
                case UP_DOWN_COUNTER: {
                    return upDownCounterLimit;
                }
                case HISTOGRAM: {
                    return histogramLimit;
                }
                case OBSERVABLE_COUNTER: {
                    return observableCounterLimit;
                }
                case OBSERVABLE_UP_DOWN_COUNTER: {
                    return observableUpDownCounterLimit;
                }
                case OBSERVABLE_GAUGE: {
                    return observableGaugeLimit;
                }
                case GAUGE: {
                    return gaugeLimit;
                }
            }
            return defaultLimit;
        };
    }

    private static int getOrDefault(@Nullable Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }
}

