/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.OtelTraceState;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.function.Function;

final class ComposableTraceIdRatioBasedSampler
implements ComposableSampler {
    private final SamplingIntent intent;
    private final String description;

    private static long calculateThreshold(double ratio) {
        return 0x100000000000000L - Math.round(ratio * 7.205759403792794E16);
    }

    ComposableTraceIdRatioBasedSampler(double ratio) {
        String thresholdStr;
        long threshold = ComposableTraceIdRatioBasedSampler.calculateThreshold(ratio);
        if (threshold == 0x100000000000000L) {
            thresholdStr = "max";
            this.intent = SamplingIntent.create(-1L, false, Attributes.empty(), Function.identity());
        } else {
            StringBuilder sb = new StringBuilder();
            OtelTraceState.serializeTh(threshold, sb);
            thresholdStr = sb.toString();
            this.intent = SamplingIntent.create(threshold, true, Attributes.empty(), Function.identity());
        }
        this.description = "ComposableTraceIdRatioBasedSampler{threshold=" + thresholdStr + ", ratio=" + ratio + "}";
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.intent;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }
}

