/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.ExemplarFilterFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.InstrumentSelectorFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.MetricReaderAndCardinalityLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.MetricReaderFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.ViewFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterConfigModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterConfiguratorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterMatcherAndConfigModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MeterProviderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ViewModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ViewSelectorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ViewStreamModel;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.CardinalityLimitSelector;
import io.opentelemetry.sdk.metrics.internal.MeterConfig;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import java.util.List;

final class MeterProviderFactory
implements Factory<MeterProviderModel, SdkMeterProviderBuilder> {
    private static final MeterProviderFactory INSTANCE = new MeterProviderFactory();

    private MeterProviderFactory() {
    }

    static MeterProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkMeterProviderBuilder create(MeterProviderModel model, DeclarativeConfigContext context) {
        MeterProviderModel.ExemplarFilter exemplarFilterModel;
        ExperimentalMeterConfiguratorModel meterConfiguratorModel;
        List<ViewModel> viewModels;
        SdkMeterProviderBuilder builder = SdkMeterProvider.builder();
        List<MetricReaderModel> readerModels = model.getReaders();
        if (readerModels != null) {
            readerModels.forEach(readerModel -> {
                MetricReaderAndCardinalityLimits readerAndCardinalityLimits = MetricReaderFactory.getInstance().create((MetricReaderModel)readerModel, context);
                CardinalityLimitSelector cardinalityLimits = readerAndCardinalityLimits.getCardinalityLimitsSelector();
                if (cardinalityLimits == null) {
                    builder.registerMetricReader(readerAndCardinalityLimits.getMetricReader());
                } else {
                    builder.registerMetricReader(readerAndCardinalityLimits.getMetricReader(), cardinalityLimits);
                }
            });
        }
        if ((viewModels = model.getViews()) != null) {
            viewModels.forEach(viewModel -> {
                ViewSelectorModel selector = FileConfigUtil.requireNonNull(viewModel.getSelector(), "view selector");
                ViewStreamModel stream = FileConfigUtil.requireNonNull(viewModel.getStream(), "view stream");
                builder.registerView(InstrumentSelectorFactory.getInstance().create(selector, context), ViewFactory.getInstance().create(stream, context));
            });
        }
        if ((meterConfiguratorModel = model.getMeterConfiguratorDevelopment()) != null) {
            List<ExperimentalMeterMatcherAndConfigModel> meterMatcherAndConfigs;
            ExperimentalMeterConfigModel defaultConfigModel = meterConfiguratorModel.getDefaultConfig();
            ScopeConfiguratorBuilder configuratorBuilder = ScopeConfigurator.builder();
            if (defaultConfigModel != null) {
                configuratorBuilder.setDefault((Object)MeterConfigFactory.INSTANCE.create(defaultConfigModel, context));
            }
            if ((meterMatcherAndConfigs = meterConfiguratorModel.getMeters()) != null) {
                for (ExperimentalMeterMatcherAndConfigModel meterMatcherAndConfig : meterMatcherAndConfigs) {
                    String name = FileConfigUtil.requireNonNull(meterMatcherAndConfig.getName(), "meter matcher name");
                    ExperimentalMeterConfigModel config = meterMatcherAndConfig.getConfig();
                    if (name == null || config == null) continue;
                    configuratorBuilder.addCondition(ScopeConfiguratorBuilder.nameMatchesGlob((String)name), (Object)MeterConfigFactory.INSTANCE.create(config, context));
                }
            }
            SdkMeterProviderUtil.setMeterConfigurator((SdkMeterProviderBuilder)builder, (ScopeConfigurator)configuratorBuilder.build());
        }
        if ((exemplarFilterModel = model.getExemplarFilter()) != null) {
            builder.setExemplarFilter(ExemplarFilterFactory.getInstance().create(exemplarFilterModel, context));
        }
        return builder;
    }

    private static class MeterConfigFactory
    implements Factory<ExperimentalMeterConfigModel, MeterConfig> {
        private static final MeterConfigFactory INSTANCE = new MeterConfigFactory();

        private MeterConfigFactory() {
        }

        @Override
        public MeterConfig create(ExperimentalMeterConfigModel model, DeclarativeConfigContext context) {
            if (model.getDisabled() != null && model.getDisabled().booleanValue()) {
                return MeterConfig.disabled();
            }
            return MeterConfig.defaultConfig();
        }
    }
}

