/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.util.Collections;
import java.util.UUID;

public class ServiceResourceDetector
implements ComponentProvider {
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey((String)"service.name");
    private static final AttributeKey<String> SERVICE_INSTANCE_ID = AttributeKey.stringKey((String)"service.instance.id");
    private static final String RANDOM_SERVICE_INSTANCE_ID = UUID.randomUUID().toString();

    public Class<Resource> getType() {
        return Resource.class;
    }

    public String getName() {
        return "service";
    }

    public Resource create(DeclarativeConfigProperties config) {
        ResourceBuilder builder = Resource.builder();
        DefaultConfigProperties properties = DefaultConfigProperties.create(Collections.emptyMap(), (ComponentLoader)config.getComponentLoader());
        String serviceName = properties.getString("otel.service.name");
        if (serviceName != null) {
            builder.put(SERVICE_NAME, (Object)serviceName).build();
        }
        builder.put(SERVICE_INSTANCE_ID, (Object)RANDOM_SERVICE_INSTANCE_ID);
        return builder.build();
    }
}

