/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.trace.jaeger.proto.api_v2.Sampling;
import io.opentelemetry.sdk.extension.trace.jaeger.proto.api_v2.SamplingManagerGrpc;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSamplerBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.PerOperationSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.RateLimitingSampler;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JaegerRemoteSampler
implements Sampler {
    private static final Logger logger = Logger.getLogger(JaegerRemoteSampler.class.getName());
    private static final String WORKER_THREAD_NAME = JaegerRemoteSampler.class.getSimpleName() + "_WorkerThread";
    private final String serviceName;
    private final SamplingManagerGrpc.SamplingManagerBlockingStub stub;
    private volatile Sampler sampler;

    JaegerRemoteSampler(String serviceName, ManagedChannel channel, int pollingIntervalMs, Sampler initialSampler) {
        this.serviceName = serviceName;
        this.stub = SamplingManagerGrpc.newBlockingStub((Channel)channel);
        this.sampler = initialSampler;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(WORKER_THREAD_NAME));
        scheduledExecutorService.scheduleAtFixedRate(this::getAndUpdateSampler, 0L, pollingIntervalMs, TimeUnit.MILLISECONDS);
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    private void getAndUpdateSampler() {
        try {
            Sampling.SamplingStrategyParameters params = Sampling.SamplingStrategyParameters.newBuilder().setServiceName(this.serviceName).build();
            Sampling.SamplingStrategyResponse response = this.stub.getSamplingStrategy(params);
            this.sampler = JaegerRemoteSampler.updateSampler(response);
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to update sampler", e);
        }
    }

    private static Sampler updateSampler(Sampling.SamplingStrategyResponse response) {
        Sampling.PerOperationSamplingStrategies operationSampling = response.getOperationSampling();
        if (operationSampling.getPerOperationStrategiesList().size() > 0) {
            Sampler defaultSampler = Sampler.traceIdRatioBased((double)operationSampling.getDefaultSamplingProbability());
            return Sampler.parentBased((Sampler)new PerOperationSampler(defaultSampler, operationSampling.getPerOperationStrategiesList()));
        }
        switch (response.getStrategyType()) {
            case PROBABILISTIC: {
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)response.getProbabilisticSampling().getSamplingRate()));
            }
            case RATE_LIMITING: {
                return Sampler.parentBased((Sampler)new RateLimitingSampler(response.getRateLimitingSampling().getMaxTracesPerSecond()));
            }
            case UNRECOGNIZED: {
                throw new AssertionError((Object)"unrecognized sampler type");
            }
        }
        throw new AssertionError((Object)"unrecognized sampler type");
    }

    public String getDescription() {
        return String.format("JaegerRemoteSampler{%s}", this.sampler);
    }

    public String toString() {
        return this.getDescription();
    }

    Sampler getSampler() {
        return this.sampler;
    }

    public static JaegerRemoteSamplerBuilder builder() {
        return new JaegerRemoteSamplerBuilder();
    }
}

