/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSampler;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class JaegerRemoteSamplerBuilder {
    private static final String DEFAULT_ENDPOINT = "localhost:14250";
    private static final int DEFAULT_POLLING_INTERVAL_MILLIS = 60000;
    private static final Sampler INITIAL_SAMPLER = Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)0.001));
    private String endpoint = "localhost:14250";
    private ManagedChannel channel;
    private String serviceName;
    private Sampler initialSampler = INITIAL_SAMPLER;
    private int pollingIntervalMillis = 60000;

    public JaegerRemoteSamplerBuilder setServiceName(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName");
        this.serviceName = serviceName;
        return this;
    }

    public JaegerRemoteSamplerBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public JaegerRemoteSamplerBuilder setChannel(ManagedChannel channel) {
        Objects.requireNonNull(channel, "channel");
        this.channel = channel;
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(int interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((interval > 0 ? 1 : 0) != 0, (String)"polling interval must be positive");
        this.pollingIntervalMillis = (int)unit.toMillis(interval);
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setPollingInterval((int)interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public JaegerRemoteSamplerBuilder setInitialSampler(Sampler initialSampler) {
        Objects.requireNonNull(initialSampler, "initialSampler");
        this.initialSampler = initialSampler;
        return this;
    }

    public JaegerRemoteSampler build() {
        if (this.channel == null) {
            this.channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
        }
        return new JaegerRemoteSampler(this.serviceName, this.channel, this.pollingIntervalMillis, this.initialSampler);
    }

    JaegerRemoteSamplerBuilder() {
    }
}

