/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.trace.jaeger.proto.api_v2.Sampling;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class PerOperationSampler
implements Sampler {
    private final Sampler defaultSampler;
    private final Map<String, Sampler> perOperationSampler;

    PerOperationSampler(Sampler defaultSampler, List<Sampling.OperationSamplingStrategy> perOperationSampling) {
        this.defaultSampler = defaultSampler;
        this.perOperationSampler = new LinkedHashMap<String, Sampler>(perOperationSampling.size());
        for (Sampling.OperationSamplingStrategy opSamplingStrategy : perOperationSampling) {
            this.perOperationSampler.put(opSamplingStrategy.getOperation(), Sampler.traceIdRatioBased((double)opSamplingStrategy.getProbabilisticSampling().getSamplingRate()));
        }
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        Sampler sampler = this.perOperationSampler.get(name);
        if (sampler == null) {
            sampler = this.defaultSampler;
        }
        return sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return String.format("PerOperationSampler{default=%s, perOperation=%s}", this.defaultSampler, this.perOperationSampler);
    }

    public String toString() {
        return this.getDescription();
    }
}

