/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.exporter.internal.marshal.CodedInputStream;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponse;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UnMarshaler;
import java.io.IOException;
import javax.annotation.Nullable;

class SamplingStrategyResponseUnMarshaler
extends UnMarshaler {
    @Nullable
    private SamplingStrategyResponse samplingStrategyResponse;

    SamplingStrategyResponseUnMarshaler() {
    }

    @Nullable
    public SamplingStrategyResponse get() {
        return this.samplingStrategyResponse;
    }

    @Override
    public void read(byte[] payload) throws IOException {
        SamplingStrategyResponse.Builder responseBuilder = new SamplingStrategyResponse.Builder();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance((byte[])payload);
            SamplingStrategyResponseUnMarshaler.parseResponse(responseBuilder, codedInputStream);
            this.samplingStrategyResponse = responseBuilder.build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void parseResponse(SamplingStrategyResponse.Builder responseBuilder, CodedInputStream input) throws IOException {
        boolean done = false;
        block7: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block7;
                }
                case 8: {
                    SamplingStrategyResponseUnMarshaler.parseSamplingStrategyType(responseBuilder, input);
                    continue block7;
                }
                case 18: {
                    input.readRawVarint32();
                    responseBuilder.setProbabilisticSamplingStrategy(SamplingStrategyResponseUnMarshaler.parseProbabilistic(input));
                    continue block7;
                }
                case 26: {
                    input.readRawVarint32();
                    responseBuilder.setRateLimitingSamplingStrategy(SamplingStrategyResponseUnMarshaler.parseRateLimiting(input));
                    continue block7;
                }
                case 34: {
                    input.readRawVarint32();
                    responseBuilder.setPerOperationSamplingStrategies(SamplingStrategyResponseUnMarshaler.parsePerOperationStrategy(input));
                    continue block7;
                }
            }
            input.skipField(tag);
        }
    }

    private static void parseSamplingStrategyType(SamplingStrategyResponse.Builder responseBuilder, CodedInputStream input) throws IOException {
        int tagValue = input.readRawVarint32();
        switch (tagValue) {
            case 0: {
                responseBuilder.setSamplingStrategyType(SamplingStrategyResponse.SamplingStrategyType.PROBABILISTIC);
                break;
            }
            case 1: {
                responseBuilder.setSamplingStrategyType(SamplingStrategyResponse.SamplingStrategyType.RATE_LIMITING);
                break;
            }
            default: {
                responseBuilder.setSamplingStrategyType(SamplingStrategyResponse.SamplingStrategyType.UNRECOGNIZED);
            }
        }
    }

    private static SamplingStrategyResponse.ProbabilisticSamplingStrategy parseProbabilistic(CodedInputStream input) throws IOException {
        SamplingStrategyResponse.ProbabilisticSamplingStrategy.Builder builder = new SamplingStrategyResponse.ProbabilisticSamplingStrategy.Builder();
        boolean done = false;
        block4: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block4;
                }
                case 9: {
                    double samplingRate = input.readDouble();
                    return builder.setSamplingRate(samplingRate).build();
                }
            }
            input.skipField(tag);
        }
        return builder.build();
    }

    private static SamplingStrategyResponse.RateLimitingSamplingStrategy parseRateLimiting(CodedInputStream input) throws IOException {
        SamplingStrategyResponse.RateLimitingSamplingStrategy.Builder builder = new SamplingStrategyResponse.RateLimitingSamplingStrategy.Builder();
        boolean done = false;
        block4: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block4;
                }
                case 8: {
                    int rate = input.readRawVarint32();
                    return builder.setMaxTracesPerSecond(rate).build();
                }
            }
            input.skipField(tag);
        }
        return builder.build();
    }

    private static SamplingStrategyResponse.PerOperationSamplingStrategies parsePerOperationStrategy(CodedInputStream input) throws IOException {
        SamplingStrategyResponse.PerOperationSamplingStrategies.Builder builder = new SamplingStrategyResponse.PerOperationSamplingStrategies.Builder();
        boolean done = false;
        block7: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block7;
                }
                case 9: {
                    double defaultProbability = input.readDouble();
                    builder.setDefaultSamplingProbability(defaultProbability);
                    continue block7;
                }
                case 17: {
                    double lowerBoundPerSecond = input.readDouble();
                    builder.setDefaultLowerBoundTracesPerSecond(lowerBoundPerSecond);
                    continue block7;
                }
                case 26: {
                    input.readRawVarint32();
                    SamplingStrategyResponse.OperationSamplingStrategy strategy = SamplingStrategyResponseUnMarshaler.parseOperationStrategy(input);
                    if (strategy == null) continue block7;
                    builder.addOperationStrategy(strategy);
                    continue block7;
                }
                case 33: {
                    double upperBoundPerSecond = input.readDouble();
                    builder.setDefaultUpperBoundTracesPerSecond(upperBoundPerSecond);
                    continue block7;
                }
            }
            input.skipField(tag);
        }
        return builder.build();
    }

    private static SamplingStrategyResponse.OperationSamplingStrategy parseOperationStrategy(CodedInputStream input) throws IOException {
        SamplingStrategyResponse.OperationSamplingStrategy.Builder builder = new SamplingStrategyResponse.OperationSamplingStrategy.Builder();
        boolean done = false;
        boolean operationParsed = false;
        boolean probabilisticSamplingParsed = false;
        while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    break;
                }
                case 10: {
                    operationParsed = true;
                    String operation = input.readStringRequireUtf8();
                    builder.setOperation(operation);
                    break;
                }
                case 18: {
                    probabilisticSamplingParsed = true;
                    input.readRawVarint32();
                    builder.setProbabilisticSamplingStrategy(SamplingStrategyResponseUnMarshaler.parseProbabilistic(input));
                    break;
                }
                default: {
                    input.skipField(tag);
                }
            }
            if (!operationParsed || !probabilisticSamplingParsed) continue;
            break;
        }
        return builder.build();
    }
}

