/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.MarshallerRemoteSamplerServiceGrpc;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyParametersMarshaler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponseUnMarshaler;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class JaegerRemoteSamplerBuilder {
    private static final String GRPC_SERVICE_NAME = "jaeger.api_v2.SamplingManager";
    static final String GRPC_ENDPOINT_PATH = "/jaeger.api_v2.SamplingManager/GetSamplingStrategy";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:14250";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:14250");
    private static final int DEFAULT_POLLING_INTERVAL_MILLIS = 60000;
    private static final Sampler INITIAL_SAMPLER = Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)0.001));
    @Nullable
    private String serviceName;
    private Sampler initialSampler = INITIAL_SAMPLER;
    private int pollingIntervalMillis = 60000;
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private final GrpcServiceBuilder<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler> delegate = GrpcService.builder("remoteSampling", 10L, DEFAULT_ENDPOINT, () -> MarshallerRemoteSamplerServiceGrpc::newFutureStub, "jaeger.api_v2.SamplingManager", "/jaeger.api_v2.SamplingManager/GetSamplingStrategy");

    public JaegerRemoteSamplerBuilder setServiceName(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName");
        this.serviceName = serviceName;
        return this;
    }

    public JaegerRemoteSamplerBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public JaegerRemoteSamplerBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        this.delegate.setTrustedCertificates(trustedCertificatesPem);
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(int interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((interval > 0 ? 1 : 0) != 0, (String)"polling interval must be positive");
        this.pollingIntervalMillis = (int)unit.toMillis(interval);
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setPollingInterval((int)interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public JaegerRemoteSamplerBuilder setInitialSampler(Sampler initialSampler) {
        Objects.requireNonNull(initialSampler, "initialSampler");
        this.initialSampler = initialSampler;
        return this;
    }

    @Deprecated
    public JaegerRemoteSamplerBuilder setChannel(ManagedChannel channel) {
        Objects.requireNonNull(channel, "channel");
        this.delegate.setChannel(channel);
        return this;
    }

    public JaegerRemoteSampler build() {
        return new JaegerRemoteSampler(this.delegate.build(), this.serviceName, this.pollingIntervalMillis, this.initialSampler);
    }

    JaegerRemoteSamplerBuilder() {
    }

    GrpcServiceBuilder<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler> getDelegate() {
        return this.delegate;
    }
}

