/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.ManagedChannel;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.DefaultGrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.OkHttpGrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UnMarshaler;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;

final class GrpcServiceUtil {
    private static final boolean USE_OKHTTP;

    static <ReqMarshalerT extends Marshaler, ResUnMarshalerT extends UnMarshaler> GrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> serviceBuilder(String type, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<Function<ManagedChannel, MarshalerServiceStub<ReqMarshalerT, ResUnMarshalerT, ?>>> stubFactory, String grpcServiceName, String grpcEndpointPath) {
        if (USE_OKHTTP) {
            return new OkHttpGrpcServiceBuilder(type, grpcEndpointPath, defaultTimeoutSecs, defaultEndpoint);
        }
        return new DefaultGrpcServiceBuilder(type, stubFactory.get(), defaultTimeoutSecs, defaultEndpoint, grpcServiceName);
    }

    private GrpcServiceUtil() {
    }

    static {
        boolean useOkhttp = true;
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            useOkhttp = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_OKHTTP = useOkhttp;
    }
}

