/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSamplerBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.PerOperationSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.RateLimitingSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyParametersMarshaler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponse;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponseUnMarshaler;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class JaegerRemoteSampler
implements Sampler,
Closeable {
    private static final Logger logger = Logger.getLogger(JaegerRemoteSampler.class.getName());
    private static final String WORKER_THREAD_NAME = JaegerRemoteSampler.class.getSimpleName() + "_WorkerThread";
    private final String serviceName;
    private final ScheduledExecutorService pollExecutor;
    private final ScheduledFuture<?> pollFuture;
    private volatile Sampler sampler;
    private final GrpcService<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler> delegate;

    JaegerRemoteSampler(GrpcService<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler> delegate, @Nullable String serviceName, int pollingIntervalMs, Sampler initialSampler) {
        this.serviceName = serviceName != null ? serviceName : "";
        this.delegate = delegate;
        this.sampler = initialSampler;
        this.pollExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(WORKER_THREAD_NAME));
        this.pollFuture = this.pollExecutor.scheduleWithFixedDelay(this::getAndUpdateSampler, 0L, pollingIntervalMs, TimeUnit.MILLISECONDS);
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    private void getAndUpdateSampler() {
        try {
            SamplingStrategyResponseUnMarshaler samplingStrategyResponseUnMarshaler = this.delegate.execute(SamplingStrategyParametersMarshaler.create(this.serviceName), new SamplingStrategyResponseUnMarshaler());
            SamplingStrategyResponse response = samplingStrategyResponseUnMarshaler.get();
            if (response != null) {
                this.sampler = JaegerRemoteSampler.updateSampler(response);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to update sampler", e);
        }
    }

    private static Sampler updateSampler(SamplingStrategyResponse response) {
        SamplingStrategyResponse.PerOperationSamplingStrategies operationSampling = response.perOperationSamplingStrategies;
        if (operationSampling.strategies.size() > 0) {
            Sampler defaultSampler = Sampler.traceIdRatioBased((double)operationSampling.defaultSamplingProbability);
            return Sampler.parentBased((Sampler)new PerOperationSampler(defaultSampler, operationSampling.strategies));
        }
        switch (response.strategyType) {
            case PROBABILISTIC: {
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)response.probabilisticSamplingStrategy.samplingRate));
            }
            case RATE_LIMITING: {
                return Sampler.parentBased((Sampler)new RateLimitingSampler(response.rateLimitingSamplingStrategy.maxTracesPerSecond));
            }
            case UNRECOGNIZED: {
                throw new AssertionError((Object)"unrecognized sampler type");
            }
        }
        throw new AssertionError((Object)"unrecognized sampler type");
    }

    public String getDescription() {
        return String.format("JaegerRemoteSampler{%s}", this.sampler);
    }

    public String toString() {
        return this.getDescription();
    }

    Sampler getSampler() {
        return this.sampler;
    }

    public static JaegerRemoteSamplerBuilder builder() {
        return new JaegerRemoteSamplerBuilder();
    }

    @Override
    public void close() {
        this.pollFuture.cancel(true);
        this.pollExecutor.shutdownNow();
        this.delegate.shutdown();
    }
}

