/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsUtil;
import io.opentelemetry.exporter.internal.grpc.OkHttpGrpcExporter;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.okhttp.OkHttpUtil;
import io.opentelemetry.exporter.internal.retry.RetryInterceptor;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcServiceBuilder;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.OkHttpGrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UnMarshaler;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

final class OkHttpGrpcServiceBuilder<ReqMarshalerT extends Marshaler, ResUnMarshalerT extends UnMarshaler>
implements GrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> {
    private final String type;
    private final String grpcEndpointPath;
    private long timeoutNanos;
    private URI endpoint;
    private boolean compressionEnabled = false;
    private final Headers.Builder headers = new Headers.Builder();
    @Nullable
    private byte[] trustedCertificatesPem;
    @Nullable
    private byte[] privateKeyPem;
    @Nullable
    private byte[] certificatePem;
    @Nullable
    private RetryPolicy retryPolicy;

    OkHttpGrpcServiceBuilder(String type, String grpcEndpointPath, long defaultTimeoutSecs, URI defaultEndpoint) {
        this.type = type;
        this.grpcEndpointPath = grpcEndpointPath;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(defaultTimeoutSecs);
        this.endpoint = defaultEndpoint;
    }

    @Override
    public GrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setChannel(ManagedChannel channel) {
        throw new UnsupportedOperationException("Only available on DefaultGrpcService");
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        Utils.checkArgument((!timeout.isNegative() ? 1 : 0) != 0, (String)"timeout must be non-negative");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = ExporterBuilderUtil.validateEndpoint((String)endpoint);
        return this;
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.compressionEnabled = true;
        return this;
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setTrustedCertificates(byte[] trustedCertificatesPem) {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    @Override
    public GrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        Objects.requireNonNull(privateKeyPem, "privateKeyPem");
        Objects.requireNonNull(certificatePem, "certificatePem");
        this.privateKeyPem = privateKeyPem;
        this.certificatePem = certificatePem;
        return this;
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> addHeader(String key, String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.headers.add(key, value);
        return this;
    }

    @Override
    public OkHttpGrpcServiceBuilder<ReqMarshalerT, ResUnMarshalerT> addRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public GrpcService<ReqMarshalerT, ResUnMarshalerT> build() {
        String endpoint;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher());
        clientBuilder.callTimeout(Duration.ofNanos(this.timeoutNanos));
        if (this.trustedCertificatesPem != null) {
            try {
                X509TrustManager trustManager = TlsUtil.trustManager((byte[])this.trustedCertificatesPem);
                X509KeyManager keyManager = null;
                if (this.privateKeyPem != null && this.certificatePem != null) {
                    keyManager = TlsUtil.keyManager((byte[])this.privateKeyPem, (byte[])this.certificatePem);
                }
                clientBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(keyManager, (TrustManager)trustManager), trustManager);
            }
            catch (SSLException e) {
                throw new IllegalStateException("Could not set trusted certificates, are they valid X.509 in PEM format?", e);
            }
        }
        if ((endpoint = this.endpoint.resolve(this.grpcEndpointPath).toString()).startsWith("http://")) {
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
        }
        this.headers.add("te", "trailers");
        if (this.compressionEnabled) {
            this.headers.add("grpc-encoding", "gzip");
        }
        if (this.retryPolicy != null) {
            clientBuilder.addInterceptor((Interceptor)new RetryInterceptor(this.retryPolicy, OkHttpGrpcExporter::isRetryable));
        }
        return new OkHttpGrpcService(this.type, clientBuilder.build(), endpoint, this.headers.build(), this.compressionEnabled);
    }
}

