/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.exporter.internal.grpc.GrpcRequestBody;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyParametersMarshaler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponseUnMarshaler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

final class OkHttpGrpcService
implements GrpcService {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private static final Logger logger = Logger.getLogger(OkHttpGrpcService.class.getName());
    private final String type;
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Headers headers;

    OkHttpGrpcService(String type, OkHttpClient client, String endpoint, Headers headers) {
        this.type = type;
        this.client = client;
        this.url = HttpUrl.get((String)endpoint);
        this.headers = headers;
    }

    @Override
    public SamplingStrategyResponseUnMarshaler execute(SamplingStrategyParametersMarshaler exportRequest, SamplingStrategyResponseUnMarshaler responseUnmarshaller) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url).headers(this.headers);
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)exportRequest, false);
        requestBuilder.post((RequestBody)requestBody);
        try {
            Response response = this.client.newCall(requestBuilder.build()).execute();
            byte[] bodyBytes = new byte[]{};
            try {
                bodyBytes = response.body().bytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String status = OkHttpGrpcService.grpcStatus(response);
            if ("0".equals(status)) {
                if (bodyBytes.length > 5) {
                    ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyBytes);
                    bodyStream.skip(5L);
                    if (bodyBytes[0] == 49) {
                        Buffer buffer = new Buffer();
                        buffer.readFrom((InputStream)bodyStream);
                        GzipSource gzipSource = new GzipSource((Source)buffer);
                        bodyBytes = Okio.buffer((Source)gzipSource).getBuffer().readByteArray();
                    } else {
                        bodyBytes = Arrays.copyOfRange(bodyBytes, 5, bodyBytes.length);
                    }
                    responseUnmarshaller.read(bodyBytes);
                    return responseUnmarshaller;
                }
                return responseUnmarshaller;
            }
            String codeMessage = status != null ? "gRPC status code " + status : "HTTP status code " + response.code();
            String errorMessage = OkHttpGrpcService.grpcMessage(response);
            if ("12".equals(status)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server responded with UNIMPLEMENTED. Full error message: " + errorMessage);
            } else if ("14".equals(status)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server is UNAVAILABLE. Make sure your service is running and reachable from this network. Full error message:" + errorMessage);
            } else {
                logger.log(Level.WARNING, "Failed to execute " + this.type + "s. Server responded with " + codeMessage + ". Error message: " + errorMessage);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. The request could not be executed. Full error message: " + e.getMessage());
        }
        return responseUnmarshaller;
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcService.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    static boolean isRetryable(Response response) {
        if (!response.isSuccessful()) {
            return false;
        }
        String grpcStatus = response.header(GRPC_STATUS);
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcService.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

