/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import com.google.common.util.concurrent.Futures;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyParametersMarshaler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.SamplingStrategyResponseUnMarshaler;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UpstreamGrpcService
implements GrpcService {
    private static final Logger logger = Logger.getLogger(UpstreamGrpcService.class.getName());
    private final String type;
    private final ManagedChannel managedChannel;
    private final MarshalerServiceStub<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler, ?> stub;
    private final long timeoutNanos;

    UpstreamGrpcService(String type, ManagedChannel channel, MarshalerServiceStub<SamplingStrategyParametersMarshaler, SamplingStrategyResponseUnMarshaler, ?> stub, long timeoutNanos) {
        this.type = type;
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.stub = stub;
    }

    @Override
    public SamplingStrategyResponseUnMarshaler execute(SamplingStrategyParametersMarshaler exportRequest, SamplingStrategyResponseUnMarshaler responseUnmarshaller) {
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(Duration.ofNanos(this.timeoutNanos));
        }
        try {
            return (SamplingStrategyResponseUnMarshaler)Futures.getUnchecked((Future)stub.export((Marshaler)exportRequest));
        }
        catch (Throwable t) {
            Status status = Status.fromThrowable((Throwable)t);
            if (status.getCode().equals((Object)Status.Code.UNIMPLEMENTED)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server responded with UNIMPLEMENTED. Full error message: " + status.getDescription());
            } else if (status.getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                logger.log(Level.SEVERE, "Failed to execute " + this.type + "s. Server is UNAVAILABLE. Make sure your service is running and reachable from this network. Full error message:" + status.getDescription());
            } else {
                logger.log(Level.WARNING, "Failed to execute " + this.type + "s. Server responded with gRPC status code " + status.getCode().value() + ". Error message: " + status.getDescription());
            }
            return responseUnmarshaller;
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        return ManagedChannelUtil.shutdownChannel((ManagedChannel)this.managedChannel);
    }
}

