/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.RateLimiter;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

class RateLimitingSampler
implements Sampler {
    static final String TYPE = "ratelimiting";
    static final AttributeKey<String> SAMPLER_TYPE = AttributeKey.stringKey((String)"sampler.type");
    static final AttributeKey<Double> SAMPLER_PARAM = AttributeKey.doubleKey((String)"sampler.param");
    private final RateLimiter rateLimiter;
    private final SamplingResult onSamplingResult;
    private final SamplingResult offSamplingResult;
    private final String description;

    RateLimitingSampler(int maxTracesPerSecond) {
        double maxBalance = (double)maxTracesPerSecond < 1.0 ? 1.0 : (double)maxTracesPerSecond;
        this.rateLimiter = new RateLimiter((double)maxTracesPerSecond, maxBalance, Clock.getDefault());
        Attributes attributes = Attributes.of(SAMPLER_TYPE, (Object)TYPE, SAMPLER_PARAM, (Object)maxTracesPerSecond);
        this.onSamplingResult = SamplingResult.create((SamplingDecision)SamplingDecision.RECORD_AND_SAMPLE, (Attributes)attributes);
        this.offSamplingResult = SamplingResult.create((SamplingDecision)SamplingDecision.DROP, (Attributes)attributes);
        this.description = "RateLimitingSampler{" + RateLimitingSampler.decimalFormat(maxTracesPerSecond) + "}";
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.rateLimiter.trySpend(1.0) ? this.onSamplingResult : this.offSamplingResult;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    private static String decimalFormat(double value) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00", decimalFormatSymbols);
        return decimalFormat.format(value);
    }
}

