/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSamplerBuilder;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;

public class JaegerRemoteSamplerComponentProvider
implements ComponentProvider<Sampler> {
    public Class<Sampler> getType() {
        return Sampler.class;
    }

    public String getName() {
        return "jaeger_remote";
    }

    public Sampler create(DeclarativeConfigProperties config) {
        DeclarativeConfigProperties initialSamplerModel;
        Long pollingIntervalMs;
        JaegerRemoteSamplerBuilder builder = JaegerRemoteSampler.builder();
        String endpoint = config.getString("endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((pollingIntervalMs = config.getLong("internal")) != null) {
            builder.setPollingInterval(Duration.ofMillis(pollingIntervalMs));
        }
        if ((initialSamplerModel = config.getStructured("initial_sampler")) != null) {
            Sampler initialSampler = DeclarativeConfiguration.createSampler((DeclarativeConfigProperties)initialSamplerModel);
            builder.setInitialSampler(initialSampler);
        }
        return builder.build();
    }
}

