/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.otproto;

import com.google.protobuf.ByteString;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.proto.trace.v1.ConstantSampler;
import io.opentelemetry.proto.trace.v1.TraceConfig;
import io.opentelemetry.sdk.trace.samplers.Sampler;

public final class TraceProtoUtils {
    private TraceProtoUtils() {
    }

    public static ByteString toProtoSpanId(String spanId) {
        return ByteString.copyFrom((byte[])SpanId.bytesFromHex((String)spanId, (int)0));
    }

    public static ByteString toProtoTraceId(String traceId) {
        return ByteString.copyFrom((byte[])TraceId.bytesFromHex((String)traceId, (int)0));
    }

    public static io.opentelemetry.sdk.trace.config.TraceConfig traceConfigFromProto(TraceConfig traceConfigProto) {
        return io.opentelemetry.sdk.trace.config.TraceConfig.getDefault().toBuilder().setSampler(TraceProtoUtils.fromProtoSampler(traceConfigProto)).setMaxNumberOfAttributes((int)traceConfigProto.getMaxNumberOfAttributes()).setMaxNumberOfEvents((int)traceConfigProto.getMaxNumberOfTimedEvents()).setMaxNumberOfLinks((int)traceConfigProto.getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent((int)traceConfigProto.getMaxNumberOfAttributesPerTimedEvent()).setMaxNumberOfAttributesPerLink((int)traceConfigProto.getMaxNumberOfAttributesPerLink()).build();
    }

    private static Sampler fromProtoSampler(TraceConfig traceConfigProto) {
        if (traceConfigProto.hasConstantSampler()) {
            ConstantSampler constantSampler = traceConfigProto.getConstantSampler();
            switch (constantSampler.getDecision()) {
                case ALWAYS_ON: {
                    return Sampler.alwaysOn();
                }
                case ALWAYS_OFF: {
                    return Sampler.alwaysOff();
                }
                case ALWAYS_PARENT: 
                case UNRECOGNIZED: {
                    throw new IllegalArgumentException("unrecognized constant sampling samplingResult");
                }
            }
        }
        if (traceConfigProto.hasTraceIdRatioBased()) {
            return Sampler.traceIdRatioBased((double)traceConfigProto.getTraceIdRatioBased().getSamplingRatio());
        }
        if (traceConfigProto.hasRateLimitingSampler()) {
            // empty if block
        }
        throw new IllegalArgumentException("unknown sampler in the trace config proto");
    }
}

