/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.resources.ResourceProvider;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class ProcessResource
extends ResourceProvider {
    protected Attributes getAttributes() {
        AttributesBuilder attributes = Attributes.builder();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        long pid = -1L;
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        int atIndex = runtimeName.indexOf(64);
        if (atIndex >= 0) {
            String pidString = runtimeName.substring(0, atIndex);
            try {
                pid = Long.parseLong(pidString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (pid >= 0L) {
            attributes.put(ResourceAttributes.PROCESS_PID, (Object)pid);
        }
        String javaHome = null;
        String osName = null;
        try {
            javaHome = System.getProperty("java.home");
            osName = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (javaHome != null) {
            StringBuilder executablePath = new StringBuilder(javaHome);
            executablePath.append(File.pathSeparatorChar).append("bin").append(File.pathSeparatorChar).append("java");
            if (osName != null && osName.toLowerCase().startsWith("windows")) {
                executablePath.append(".exe");
            }
            attributes.put(ResourceAttributes.PROCESS_EXECUTABLE_PATH, (Object)executablePath.toString());
            StringBuilder commandLine = new StringBuilder(executablePath);
            for (String arg : runtime.getInputArguments()) {
                commandLine.append(' ').append(arg);
            }
            attributes.put(ResourceAttributes.PROCESS_COMMAND_LINE, (Object)commandLine.toString());
        }
        return attributes.build();
    }
}

