/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.resources.ResourceProvider;
import javax.annotation.Nullable;

public final class OsResource
extends ResourceProvider {
    protected Attributes getAttributes() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (SecurityException t) {
            return Attributes.empty();
        }
        if (os == null) {
            return Attributes.empty();
        }
        AttributesBuilder attributes = Attributes.builder();
        String osName = OsResource.getOs(os);
        if (osName != null) {
            attributes.put(ResourceAttributes.OS_NAME, (Object)osName);
        }
        String version = null;
        try {
            version = System.getProperty("os.version");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String osDescription = version != null ? os + ' ' + version : os;
        attributes.put(ResourceAttributes.OS_DESCRIPTION, (Object)osDescription);
        return attributes.build();
    }

    @Nullable
    private static String getOs(String os) {
        if ((os = os.toLowerCase()).startsWith("windows")) {
            return "WINDOWS";
        }
        if (os.startsWith("linux")) {
            return "LINUX";
        }
        if (os.startsWith("mac")) {
            return "DARWIN";
        }
        if (os.startsWith("freebsd")) {
            return "FREEBSD";
        }
        if (os.startsWith("netbsd")) {
            return "NETBSD";
        }
        if (os.startsWith("openbsd")) {
            return "OPENBSD";
        }
        if (os.startsWith("dragonflybsd")) {
            return "DRAGONFLYBSD";
        }
        if (os.startsWith("hp-ux")) {
            return "HPUX";
        }
        if (os.startsWith("aix")) {
            return "AIX";
        }
        if (os.startsWith("solaris")) {
            return "SOLARIS";
        }
        if (os.startsWith("z/os")) {
            return "ZOS";
        }
        return null;
    }
}

