/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.extension.resources.ProcessPid;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class ProcessResource {
    private static final Resource INSTANCE = ProcessResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        try {
            return ProcessResource.doBuildResource();
        }
        catch (LinkageError t) {
            return Resource.empty();
        }
    }

    @IgnoreJRERequirement
    private static Resource doBuildResource() {
        AttributesBuilder attributes = Attributes.builder();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        long pid = ProcessPid.getPid();
        if (pid >= 0L) {
            attributes.put(ResourceAttributes.PROCESS_PID, (Object)pid);
        }
        String javaHome = null;
        String osName = null;
        try {
            javaHome = System.getProperty("java.home");
            osName = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (javaHome != null) {
            StringBuilder executablePath = new StringBuilder(javaHome);
            executablePath.append(File.pathSeparatorChar).append("bin").append(File.pathSeparatorChar).append("java");
            if (osName != null && osName.toLowerCase().startsWith("windows")) {
                executablePath.append(".exe");
            }
            attributes.put(ResourceAttributes.PROCESS_EXECUTABLE_PATH, (Object)executablePath.toString());
            StringBuilder commandLine = new StringBuilder(executablePath);
            for (String arg : runtime.getInputArguments()) {
                commandLine.append(' ').append(arg);
            }
            attributes.put(ResourceAttributes.PROCESS_COMMAND_LINE, (Object)commandLine.toString());
        }
        return Resource.create((Attributes)attributes.build(), (String)"https://opentelemetry.io/schemas/1.12.0");
    }

    private ProcessResource() {
    }
}

